/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.DefineInvocation;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final NamespaceDescriptor descriptor;
    private final FileDeclarationVisitor visitor;
    private final NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> definitionPlace;

    NamespaceTranslator(final @NotNull NamespaceDescriptor descriptor, final @NotNull Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (descriptorToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.visitor = new FileDeclarationVisitor();
        this.definitionPlace = new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

            @Override
            @NotNull
            public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                DefineInvocation defineInvocation = (DefineInvocation)descriptorToDefineInvocation.get(descriptor);
                if (defineInvocation == null) {
                    defineInvocation = NamespaceTranslator.this.createDefinitionPlace(null, descriptorToDefineInvocation);
                }
                Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> trinity = LiteralFunctionTranslator.createPlace(defineInvocation.getMembers(), NamespaceTranslator.this.context().getQualifiedReference(descriptor));
                if (trinity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$1", "compute"));
                }
                return trinity;
            }
        };
    }

    public void translate(JetFile file) {
        this.context().literalFunctionTranslator().setDefinitionPlace(this.definitionPlace);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
        this.context().literalFunctionTranslator().setDefinitionPlace(null);
    }

    private DefineInvocation createDefinitionPlace(@Nullable JsExpression initializer, Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        DefineInvocation place = DefineInvocation.createDefineInvocation(this.descriptor, initializer, new JsObjectLiteral(this.visitor.getResult(), true), this.context());
        descriptorToDefineInvocation.put(this.descriptor, place);
        this.addToParent((NamespaceDescriptor)this.descriptor.getContainingDeclaration(), this.getEntry(this.descriptor, place), descriptorToDefineInvocation);
        return place;
    }

    public void add(@NotNull Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        if (descriptorToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "add"));
        }
        JsFunction initializer = this.visitor.initializerStatements.isEmpty() ? null : this.visitor.initializer;
        DefineInvocation defineInvocation = descriptorToDefineInvocation.get(this.descriptor);
        if (defineInvocation == null) {
            if (initializer != null || !this.visitor.getResult().isEmpty()) {
                this.createDefinitionPlace(initializer, descriptorToDefineInvocation);
            }
        } else {
            List<JsPropertyInitializer> listFromPlace;
            if (initializer != null) {
                assert (defineInvocation.getInitializer() == JsLiteral.NULL);
                defineInvocation.setInitializer(initializer);
            }
            if ((listFromPlace = defineInvocation.getMembers()) != this.visitor.getResult()) {
                listFromPlace.addAll(this.visitor.getResult());
            }
        }
    }

    private JsPropertyInitializer getEntry(@NotNull NamespaceDescriptor descriptor, DefineInvocation defineInvocation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "getEntry"));
        }
        return new JsPropertyInitializer(this.context().getNameForDescriptor(descriptor).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation.asList()));
    }

    private boolean addEntryIfParentExists(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, DefineInvocation> descriptorToDeclarationPlace) {
        DefineInvocation parentDefineInvocation = descriptorToDeclarationPlace.get(parentDescriptor);
        if (parentDefineInvocation != null) {
            parentDefineInvocation.getMembers().add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        while (!this.addEntryIfParentExists(parentDescriptor, entry, descriptorToDefineInvocation)) {
            JsObjectLiteral members = new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true);
            DefineInvocation defineInvocation = DefineInvocation.createDefineInvocation(parentDescriptor, null, members, this.context());
            entry = this.getEntry(parentDescriptor, defineInvocation);
            descriptorToDefineInvocation.put(parentDescriptor, defineInvocation);
            parentDescriptor = (NamespaceDescriptor)parentDescriptor.getContainingDeclaration();
        }
    }

    private class FileDeclarationVisitor
    extends DeclarationBodyVisitor {
        private final JsFunction initializer;
        private final TranslationContext initializerContext;
        private final List<JsStatement> initializerStatements;
        private final InitializerVisitor initializerVisitor;

        private FileDeclarationVisitor() {
            this.initializer = JsAstUtils.createFunctionWithEmptyBody(NamespaceTranslator.this.context().scope());
            this.initializerContext = NamespaceTranslator.this.context().contextWithScope(this.initializer);
            this.initializerStatements = this.initializer.getBody().getStatements();
            this.initializerVisitor = new InitializerVisitor(this.initializerStatements);
        }

        @Override
        public Void visitClass(@NotNull JetClass declaration, @NotNull TranslationContext context) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitClass"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitClass"));
            }
            JsPropertyInitializer entry = context.classDeclarationTranslator().translate(declaration, context);
            if (entry != null) {
                this.result.add(entry);
            }
            return null;
        }

        @Override
        public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitObjectDeclaration"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitObjectDeclaration"));
            }
            InitializerUtils.generateObjectInitializer(declaration, this.initializerStatements, context);
            return null;
        }

        @Override
        public Void visitProperty(@NotNull JetProperty property2, @NotNull TranslationContext context) {
            JsStatement delegate;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitProperty"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitProperty"));
            }
            super.visitProperty(property2, context);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                JsExpression value = Translation.translateAsExpression(initializer, this.initializerContext);
                PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), property2);
                this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(context, propertyDescriptor, value));
            }
            if ((delegate = InitializerUtils.generateInitializerForDelegate(context, property2)) != null) {
                this.initializerStatements.add(delegate);
            }
            return null;
        }

        @Override
        public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, @NotNull TranslationContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitAnonymousInitializer"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$FileDeclarationVisitor", "visitAnonymousInitializer"));
            }
            expression.accept(this.initializerVisitor, this.initializerContext);
            return null;
        }
    }
}

