/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpressionBase;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.expression.MultiDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.StringTemplateTranslator;
import org.jetbrains.k2js.translate.expression.TryTranslator;
import org.jetbrains.k2js.translate.expression.WhenTranslator;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.k2js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslationUtils;
import org.jetbrains.k2js.translate.reference.CallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;
import org.jetbrains.k2js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        CompileTimeConstant<?> compileTimeValue = context.bindingContext().get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeValue == null) {
            if (expression.getNode().getElementType() == JetNodeTypes.BOOLEAN_CONSTANT) {
                JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean(Boolean.valueOf(expression.getText()));
                if (jsBooleanLiteral == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
                }
                return jsBooleanLiteral;
            }
            if (expression.getNode().getElementType() == JetNodeTypes.INTEGER_CONSTANT) {
                JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(Integer.parseInt(expression.getText()));
                if (jsNumberLiteral == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
                }
                return jsNumberLiteral;
            }
        }
        assert (compileTimeValue != null);
        if (compileTimeValue instanceof NullValue) {
            JsNullLiteral jsNullLiteral = JsLiteral.NULL;
            if (jsNullLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNullLiteral;
        }
        Object value = compileTimeValue.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).intValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Number) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).doubleValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Boolean) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean((Boolean)value);
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsBooleanLiteral;
        }
        if (value instanceof String) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral((String)value);
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        if (value instanceof Character) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral(value.toString());
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        throw new AssertionError((Object)ErrorReportingUtils.message(expression, "Unsupported constant expression"));
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull JetBlockExpression jetBlock, @NotNull TranslationContext context) {
        if (jetBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetBlock", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        List<JetElement> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        TranslationContext blockContext = context.innerBlock(jsBlock);
        for (JetElement statement : statements) {
            assert (statement instanceof JetExpression) : "Elements in JetBlockExpression should be of type JetExpression";
            JsNode jsNode = statement.accept(this, blockContext);
            if (jsNode == null) continue;
            jsBlock.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        JetExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer = Translation.translateAsExpression(jetInitializer, context);
        return MultiDeclarationTranslator.translate(multiDeclaration, context.scope().declareTemporary(), initializer, context);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull JetReturnExpression jetReturnExpression, @NotNull TranslationContext context) {
        if (jetReturnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetReturnExpression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        JetExpression returned = jetReturnExpression.getReturnedExpression();
        JsNode jsNode = new JsReturn(returned != null ? Translation.translateAsExpression(returned, context) : null).source(jetReturnExpression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, @NotNull TranslationContext context) {
        JsNode translated;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        JetExpression expressionInside = expression.getExpression();
        if (expressionInside != null && (translated = expressionInside.accept(this, context)) != null) {
            JsNode jsNode = translated;
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
            }
            return jsNode;
        }
        JsEmpty jsEmpty = context.program().getEmptyStatement();
        if (jsEmpty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull JetProperty expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        VariableDescriptor descriptor = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, expression);
        JsExpression initializer = TranslationUtils.translateInitializerForProperty(expression, context);
        JsName name = context.getNameForDescriptor(descriptor);
        if (descriptor.isVar() && context.bindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, descriptor) != null) {
            JsNameRef alias = new JsNameRef("v", (JsExpression)new JsNameRef(name));
            initializer = JsAstUtils.wrapValue(alias, initializer == null ? JsLiteral.NULL : initializer);
            context.aliasingContext().registerAlias(descriptor, alias);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull JetCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        JsExpression jsExpression = CallExpressionTranslator.translate(expression, null, CallType.NORMAL, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull JetIfExpression expression, @NotNull TranslationContext context) {
        boolean canBeJsExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        JsExpression testExpression = this.translateConditionExpression(expression.getCondition(), context);
        JetExpression thenExpression = expression.getThen();
        JetExpression elseExpression = expression.getElse();
        assert (thenExpression != null);
        JsNode thenNode = thenExpression.accept(this, context);
        JsNode elseNode = elseExpression == null ? null : elseExpression.accept(this, context);
        boolean isKotlinStatement = BindingUtils.isStatement(context.bindingContext(), expression);
        boolean bl = canBeJsExpression = thenNode instanceof JsExpression && elseNode instanceof JsExpression;
        if (!isKotlinStatement && canBeJsExpression) {
            JsExpression jsExpression = new JsConditional(testExpression, JsAstUtils.convertToExpression(thenNode), JsAstUtils.convertToExpression(elseNode)).source(expression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
            }
            return jsExpression;
        }
        JsIf ifStatement = new JsIf(testExpression, JsAstUtils.convertToStatement(thenNode), elseNode == null ? null : JsAstUtils.convertToStatement(elseNode));
        ifStatement.source(expression);
        if (isKotlinStatement) {
            JsIf jsIf = ifStatement;
            if (jsIf == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
            }
            return jsIf;
        }
        TemporaryVariable result = context.declareTemporary(null);
        AssignToExpressionMutator saveResultToTemporaryMutator = new AssignToExpressionMutator(result.reference());
        context.addStatementToCurrentBlock(LastExpressionMutator.mutateLastExpression(ifStatement, saveResultToTemporaryMutator));
        JsNameRef jsNameRef = result.reference();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleName(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsStatement translateNullableExpressionAsNotNullStatement(@Nullable JetExpression nullableExpression, @NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateNullableExpressionAsNotNullStatement"));
        }
        if (nullableExpression == null) {
            JsEmpty jsEmpty = context.program().getEmptyStatement();
            if (jsEmpty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateNullableExpressionAsNotNullStatement"));
            }
            return jsEmpty;
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(nullableExpression.accept(this, context));
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateNullableExpressionAsNotNullStatement"));
        }
        return jsStatement;
    }

    @NotNull
    private JsExpression translateConditionExpression(@Nullable JetExpression expression, @NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConditionExpression"));
        }
        JsExpression jsCondition = this.translateNullableExpression(expression, context);
        assert (jsCondition != null) : "Condition should not be empty";
        JsExpression jsExpression = JsAstUtils.convertToExpression(jsCondition);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConditionExpression"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression translateNullableExpression(@Nullable JetExpression expression, @NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateNullableExpression"));
        }
        if (expression == null) {
            return null;
        }
        return JsAstUtils.convertToExpression(expression.accept(this, context));
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull JetWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        JsNode jsNode = this.createWhile(new JsWhile(), expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull JetDoWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        JsNode jsNode = this.createWhile(new JsDoWhile(), expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        return jsNode;
    }

    private JsNode createWhile(@NotNull JsWhile result, @NotNull JetWhileExpressionBase expression, @NotNull TranslationContext context) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "createWhile"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "createWhile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "createWhile"));
        }
        result.setCondition(this.translateConditionExpression(expression.getCondition(), context));
        result.setBody(this.translateNullableExpressionAsNotNullStatement(expression.getBody(), context));
        return result.source(expression);
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        JsStringLiteral stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression, context);
        if (stringLiteral != null) {
            JsStringLiteral jsStringLiteral = stringLiteral;
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
            }
            return jsStringLiteral;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression);
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return context.program().getStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull JetDotQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        JsExpression jsExpression = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull JetPrefixExpression expression, @NotNull TranslationContext context) {
        JsNode result;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        JetSimpleNameExpression operationReference = expression.getOperationReference();
        IElementType operationToken = operationReference.getReferencedNameElementType();
        if (JetTokens.LABELS.contains(operationToken)) {
            JetExpression baseExpression = expression.getBaseExpression();
            assert (baseExpression != null);
            result = new JsLabel(context.scope().declareName(ExpressionVisitor.getReferencedName(operationReference)), JsAstUtils.convertToStatement(baseExpression.accept(this, context)));
        } else {
            result = UnaryOperationTranslator.translate(expression, context);
        }
        JsNode jsNode = result.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull JetPostfixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull JetIsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        JsExpression jsExpression = Translation.patternTranslator(context).translateIsExpression(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull JetSafeQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        JsExpression jsExpression = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        return jsExpression;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        return WhenTranslator.translate(expression, context);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression.getLeft(), context);
        if (expression.getOperationReference().getReferencedNameElementType() != JetTokens.AS_KEYWORD) {
            JsExpression jsExpression2 = jsExpression.source(expression);
            if (jsExpression2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression2;
        }
        JetTypeReference type = expression.getRight();
        assert (type != null);
        if (BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.TYPE, type).isNullable()) {
            JsExpression jsExpression3 = jsExpression.source(expression);
            if (jsExpression3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression3;
        }
        JsExpression jsExpression4 = TranslationUtils.sure(jsExpression, context).source(expression);
        if (jsExpression4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        return jsExpression4;
    }

    private static String getReferencedName(JetSimpleNameExpression expression) {
        String name = expression.getReferencedName();
        return name.charAt(0) == '@' ? name.substring(1) + '$' : name;
    }

    private static String getTargetLabel(JetLabelQualifiedExpression expression, TranslationContext context) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        JsName name = context.scope().findName(ExpressionVisitor.getReferencedName(labelElement));
        assert (name != null);
        return name.getIdent();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull JetBreakExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull JetContinueExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression.getFunctionLiteral());
        JsExpression jsExpression = context.literalFunctionTranslator().translate(expression.getFunctionLiteral(), descriptor, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull JetNamedFunction expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        JsExpression alias = context.literalFunctionTranslator().translate(expression, descriptor, context);
        JsName name = context.scope().declareFreshName(descriptor.getName().asString());
        context.aliasingContext().registerAlias(descriptor, name.makeRef());
        JsNode jsNode = new JsVars(new JsVars.JsVar(name, alias)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull JetThisExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression.getText();
        JsExpression jsExpression = context.getThisObject(thisExpression).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull JetSuperExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        DeclarationDescriptor superClassDescriptor = context.bindingContext().get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        assert (superClassDescriptor != null) : ErrorReportingUtils.message(expression);
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(superClassDescriptor, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        JsNode jsNode = ForTranslator.translate(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull JetTryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        JsNode jsNode = TryTranslator.translate(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull JetThrowExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        JsExpression jsExpression = ClassTranslator.generateObjectLiteral(expression.getObjectDeclaration(), context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitObjectDeclaration(@NotNull JetObjectDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        JetObjectDeclarationName objectDeclarationName = PsiUtils.getObjectDeclarationName(expression);
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(context.bindingContext(), objectDeclarationName);
        JsName propertyName = context.getNameForDescriptor(descriptor);
        JsInvocation value = ClassTranslator.generateClassCreation(expression, context);
        JsNode jsNode = JsAstUtils.newVar(propertyName, value).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        return jsNode;
    }
}

