/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        PropertyAccessTranslator result = PropertyAccessTranslator.newInstance(PsiUtils.getNotNullSimpleNameSelector(expression), receiver, CallType.getCallTypeForQualifiedExpression(expression), context);
        result.setCallType(CallType.getCallTypeForQualifiedExpression(expression));
        PropertyAccessTranslator propertyAccessTranslator = result;
        if (propertyAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        return propertyAccessTranslator;
    }

    @NotNull
    public static JsExpression translateQualifiedExpression(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        JetExpression selector = PsiUtils.getSelector(expression);
        CallType callType = CallType.getCallTypeForQualifiedExpression(expression);
        JsExpression jsExpression = QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver, selector, callType, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression dispatchToCorrectTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (PropertyAccessTranslator.canBePropertyGetterCall(selector, context)) {
            assert (selector instanceof JetSimpleNameExpression) : "Selectors for properties must be simple names.";
            JsExpression jsExpression = PropertyAccessTranslator.translateAsPropertyGetterCall((JetSimpleNameExpression)selector, receiver, callType, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        if (selector instanceof JetCallExpression) {
            JsExpression jsExpression = QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver, selector, callType, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        if (selector instanceof JetSimpleNameExpression) {
            JsExpression jsExpression = ReferenceTranslator.translateSimpleName((JetSimpleNameExpression)selector, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    private static JsExpression invokeCallExpressionTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull CallType callType, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        try {
            jsExpression = CallExpressionTranslator.translate((JetCallExpression)selector, receiver, callType, context);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        return jsExpression;
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        JetExpression receiverExpression = expression.getReceiverExpression();
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression, context)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context);
    }

    private static boolean isFullQualifierForExpression(@Nullable JetExpression receiverExpression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/QualifiedExpressionTranslator", "isFullQualifierForExpression"));
        }
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof JetReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), (JetReferenceExpression)receiverExpression)) instanceof NamespaceDescriptor) {
            return true;
        }
        if (receiverExpression instanceof JetQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((JetQualifiedExpression)receiverExpression).getSelectorExpression(), context);
        }
        return false;
    }
}

