/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.colors.ColorKey");
    private static final Color NULL_COLOR = Gray._0;
    private final String myExternalName;
    private Color myDefaultColor = NULL_COLOR;
    private static final Map<String, ColorKey> ourRegistry = new HashMap<String, ColorKey>();

    private ColorKey(String externalName) {
        this.myExternalName = externalName;
        if (ourRegistry.containsKey(this.myExternalName)) {
            LOG.error("Key " + this.myExternalName + " already registered.");
        } else {
            ourRegistry.put(this.myExternalName, this);
        }
    }

    public static ColorKey find(String externalName) {
        ColorKey key = ourRegistry.get(externalName);
        return key != null ? key : new ColorKey(externalName);
    }

    public String toString() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(ColorKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public static ColorKey createColorKey(@NonNls String externalName) {
        return ColorKey.find(externalName);
    }
}

