/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.ide.caches.FileContent;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.ClsFileDecompiledPsiFileProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements Queryable,
PsiClassOwnerEx,
PsiCompiledFile,
PsiJavaFile,
PsiFileEx,
PsiFileWithStubSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final PsiManagerImpl myManager;
    private final boolean myIsForDecompiling;
    private final FileViewProvider myViewProvider;
    private volatile SoftReference<StubTree> myStub;
    private volatile TreeElement myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private boolean myIsPhysical;

    private ClsFileImpl(@NotNull PsiManagerImpl manager, @NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        super(null);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myPackageStatement = null;
        this.myIsPhysical = true;
        this.myManager = manager;
        this.myIsForDecompiling = forDecompiling;
        this.myViewProvider = viewProvider;
        JavaElementType.CLASS.getIndex();
    }

    public ClsFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this(manager, viewProvider, false);
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        if (this.myIsForDecompiling) {
            return true;
        }
        VirtualFile vFile = this.getVirtualFile();
        return vFile.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getClasses();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        this.getStub();
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            statement = new ClsPackageStatementImpl(this);
        }
        return statement.getPackageName() != null ? statement : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getPackageName"));
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getOnDemandImports"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getSingleClassImports"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackages"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackageReferences"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsFileImpl", "setName"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsFileImpl", "appendMirrorText"));
        }
        buffer.append("\n");
        buffer.append("  // IntelliJ API Decompiler stub source generated from a class file\n");
        buffer.append("  // Implementation of methods is not available\n");
        buffer.append("\n");
        ClsFileImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
        PsiClass[] classes = this.getClasses();
        if (classes.length > 0) {
            ClsFileImpl.appendText(classes[0], 0, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsFileImpl", "setMirror"));
        }
        Object mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        ClsFileImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
        ClsFileImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiFile navigationElement;
            if (!(customNavigationPolicy instanceof ClsCustomNavigationPolicyEx) || (navigationElement = ((ClsCustomNavigationPolicyEx)customNavigationPolicy).getFileNavigationElement(this)) == null) continue;
            PsiFile psiFile = navigationElement;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
            }
            return psiFile;
        }
        PsiElement psiElement = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = this.myMirrorFileElement;
        if (mirrorTreeElement == null) {
            Object object2 = this.myMirrorLock;
            synchronized (object2) {
                mirrorTreeElement = this.myMirrorFileElement;
                if (mirrorTreeElement == null) {
                    VirtualFile file = this.getVirtualFile();
                    String mirrorText = ClsFileImpl.decompile(this.getManager(), file);
                    String ext = JavaFileType.INSTANCE.getDefaultExtension();
                    PsiClass[] classes = this.getClasses();
                    String fileName = (classes.length > 0 ? classes[0].getName() : file.getNameWithoutExtension()) + "." + ext;
                    PsiFileFactory factory = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, JavaLanguage.INSTANCE, (CharSequence)mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getSourceLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    NonCancelableSection section = ProgressIndicatorProvider.startNonCancelableSectionIfSupported();
                    try {
                        this.setMirror(mirrorTreeElement);
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file.getPath(), e);
                    }
                    finally {
                        section.done();
                    }
                    this.myMirrorFileElement = mirrorTreeElement;
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    @NotNull
    public LanguageLevel getSourceLanguageLevel() {
        List<StubElement> stubs = this.getStub().getChildrenStubs();
        LanguageLevel languageLevel = !stubs.isEmpty() ? ((PsiClassStub)stubs.get(0)).getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getSourceLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        for (ClsFileDecompiledPsiFileProvider provider : Extensions.getExtensions(ClsFileDecompiledPsiFileProvider.EP_NAME)) {
            PsiFile decompiledPsiFile = provider.getDecompiledPsiFile(this);
            if (decompiledPsiFile == null) continue;
            return decompiledPsiFile;
        }
        return (PsiFile)this.getMirror();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsFileImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        ClsFileImpl clsFileImpl = this;
        if (clsFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getOriginalFile"));
        }
        return clsFileImpl;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getFileType"));
        }
        return javaClassFileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public void subtreeChanged() {
    }

    public static String decompile(PsiManager manager, VirtualFile file) {
        PsiFile psi;
        ClsFileImpl psiFile = null;
        FileViewProvider provider = ((PsiManagerEx)manager).getFileManager().findViewProvider(file);
        if (provider != null && (psi = provider.getPsi(provider.getBaseLanguage())) instanceof ClsFileImpl) {
            psiFile = (ClsFileImpl)psi;
        }
        if (psiFile == null) {
            psiFile = new ClsFileImpl((PsiManagerImpl)manager, new ClassFileViewProvider(manager, file), true);
        }
        StringBuilder buffer = new StringBuilder();
        psiFile.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStub"));
        }
        return psiClassHolderFileStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            LOG.warn("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted.classfiles", true));
        }
        Object object2 = this.myStubLock;
        synchronized (object2) {
            stubTree = SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            ((PsiFileStubImpl)stubTree.getRoot()).setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
        }
        return stubTree4;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        return null;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object2 = this.myStubLock;
        synchronized (object2) {
            StubTree stubTree = SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).setPsi(null);
            }
        }
        ClsPackageStatementImpl packageStatement = new ClsPackageStatementImpl(this);
        Object object3 = this.myMirrorLock;
        synchronized (object3) {
            this.myMirrorFileElement = null;
            this.myPackageStatement = packageStatement;
        }
    }

    @Override
    public PsiFile cacheCopy(FileContent content) {
        return this;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }
}

