/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.ICompositeElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends ILightStubElementType<StubT, PsiT>
implements ICompositeElementType {
    private final boolean myLeftBound;

    protected JavaStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaStubElementType", "<init>"));
        }
        this(debugName, false);
    }

    protected JavaStubElementType(@NotNull @NonNls String debugName, boolean leftBound) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaStubElementType", "<init>"));
        }
        super(debugName, JavaLanguage.INSTANCE);
        this.myLeftBound = leftBound;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "java." + this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaStubElementType", "getExternalId"));
        }
        return string;
    }

    protected StubPsiFactory getPsiFactory(StubT stub) {
        return this.getFileStub(stub).getPsiFactory();
    }

    public boolean isCompiled(StubT stub) {
        return this.getFileStub(stub).isCompiled();
    }

    private PsiJavaFileStub getFileStub(StubT stub) {
        Object parent = stub;
        while (!(parent instanceof PsiFileStub)) {
            parent = parent.getParentStub();
        }
        return (PsiJavaFileStub)parent;
    }

    @Override
    public abstract PsiT createPsi(@NotNull ASTNode var1);

    @Override
    public final StubT createStub(@NotNull PsiT psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaStubElementType", "createStub"));
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @Override
    public boolean isLeftBound() {
        return this.myLeftBound;
    }
}

