/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.SoftHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SoftKeySoftValueHashMap<K, V>
implements Map<K, V> {
    private final SoftHashMap<K, MyValueReference<K, V>> mySoftKeyMap = new SoftHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    boolean processQueue() {
        MyValueReference ref;
        boolean processed = this.mySoftKeyMap.processQueue();
        while ((ref = (MyValueReference)this.myQueue.poll()) != null) {
            RefHashMap.Key key = ref.key;
            this.mySoftKeyMap.removeKey(key);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        MyValueReference ref = (MyValueReference)this.mySoftKeyMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> softKey = this.mySoftKeyMap.createKey(key);
        MyValueReference reference = new MyValueReference(softKey, value, this.myQueue);
        MyValueReference oldRef = this.mySoftKeyMap.putKey(softKey, reference);
        return oldRef == null ? null : (V)oldRef.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyValueReference ref = (MyValueReference)this.mySoftKeyMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftKeySoftValueHashMap", "putAll"));
        }
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.mySoftKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.mySoftKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mySoftKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.mySoftKeyMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftKeySoftValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.mySoftKeyMap.values();
        for (MyValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftKeySoftValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static class MyValueReference<K, V>
    extends SoftReference<V> {
        private final RefHashMap.Key<K> key;

        private MyValueReference(RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

