/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public class LazySubstitutingClassDescriptor
implements ClassDescriptor {
    private final ClassDescriptor original;
    private final TypeSubstitutor originalSubstitutor;
    private TypeSubstitutor newSubstitutor;
    private List<TypeParameterDescriptor> typeParameters;
    private TypeConstructor typeConstructor;

    public LazySubstitutingClassDescriptor(ClassDescriptor descriptor, TypeSubstitutor substitutor) {
        this.original = descriptor;
        this.originalSubstitutor = substitutor;
    }

    private TypeSubstitutor getSubstitutor() {
        if (this.newSubstitutor == null) {
            if (this.originalSubstitutor.isEmpty()) {
                this.newSubstitutor = this.originalSubstitutor;
            } else {
                this.typeParameters = Lists.newArrayList();
                this.newSubstitutor = DescriptorSubstitutor.substituteTypeParameters(this.original.getTypeConstructor().getParameters(), this.originalSubstitutor, this, this.typeParameters);
            }
        }
        return this.newSubstitutor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor originalTypeConstructor = this.original.getTypeConstructor();
        if (this.originalSubstitutor.isEmpty()) {
            TypeConstructor typeConstructor = originalTypeConstructor;
            if (typeConstructor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
            }
            return typeConstructor;
        }
        if (this.typeConstructor == null) {
            TypeSubstitutor substitutor = this.getSubstitutor();
            ArrayList<JetType> supertypes = Lists.newArrayList();
            for (JetType supertype : originalTypeConstructor.getSupertypes()) {
                supertypes.add(substitutor.substitute(supertype, Variance.INVARIANT));
            }
            this.typeConstructor = new TypeConstructorImpl(this, originalTypeConstructor.getAnnotations(), originalTypeConstructor.isFinal(), originalTypeConstructor.toString(), this.typeParameters, supertypes);
        }
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(List<? extends TypeProjection> typeArguments) {
        JetScope memberScope = this.original.getMemberScope(typeArguments);
        if (this.originalSubstitutor.isEmpty()) {
            JetScope jetScope = memberScope;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
            }
            return jetScope;
        }
        SubstitutingScope substitutingScope = new SubstitutingScope(memberScope, this.getSubstitutor());
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        ArrayList<ConstructorDescriptor> r = Lists.newArrayList();
        for (ConstructorDescriptor constructor : this.original.getConstructors()) {
            r.add((ConstructorDescriptor)constructor.substitute(this.getSubstitutor()));
        }
        ArrayList<ConstructorDescriptor> arrayList = r;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getConstructors"));
        }
        return arrayList;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.original.getAnnotations();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.original.getName();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        DeclarationDescriptor declarationDescriptor = this.original.getOriginal();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getOriginal"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.original.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        if (substitutor.isEmpty()) {
            LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = this;
            if (lazySubstitutingClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
            }
            return lazySubstitutingClassDescriptor;
        }
        LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = new LazySubstitutingClassDescriptor(this, TypeSubstitutor.create(substitutor.getSubstitution(), this.getSubstitutor().getSubstitution()));
        if (lazySubstitutingClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        return lazySubstitutingClassDescriptor;
    }

    @Override
    public JetType getClassObjectType() {
        return this.original.getClassObjectType();
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return this.original.getClassObjectDescriptor();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.original.getKind();
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.original.getModality();
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.original.getVisibility();
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.original.isInner();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitClassDescriptor(this, data2);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        JetScope jetScope = this.original.getUnsubstitutedInnerClassesScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazySubstitutingClassDescriptor", "getUnsubstitutedInnerClassesScope"));
        }
        return jetScope;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.original.getUnsubstitutedPrimaryConstructor();
    }
}

