/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.JetParser;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetFileStubBuilder;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetFileStubImpl;
import org.jetbrains.jet.plugin.JetLanguage;

public class JetFileElementType
extends IStubFileElementType<PsiJetFileStub> {
    public static final int STUB_VERSION = 24;

    public JetFileElementType() {
        super("jet.FILE", JetLanguage.INSTANCE);
    }

    protected JetFileElementType(@NonNls String debugName) {
        super(debugName, JetLanguage.INSTANCE);
    }

    @Override
    public StubBuilder getBuilder() {
        return new JetFileStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 24;
    }

    @Override
    public String getExternalId() {
        return "jet.FILE";
    }

    @Override
    public void serialize(PsiJetFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getPackageName());
        dataStream.writeBoolean(stub.isScript());
    }

    @Override
    public PsiJetFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef packName = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        return new PsiJetFileStubImpl(null, packName, isScript);
    }

    @Override
    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        Project project = psi.getProject();
        Language languageForParser = this.getLanguageForParser(psi);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, languageForParser, chameleon.getChars());
        JetParser parser = (JetParser)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageForParser)).createParser(project);
        return parser.parse(this, builder, psi.getContainingFile()).getFirstChildNode();
    }

    @Override
    public void indexStub(PsiJetFileStub stub, IndexSink sink) {
        StubIndexServiceFactory.getInstance().indexFile(stub, sink);
    }
}

