/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.analyze;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.analyzer.AnalyzerFacadeForEverything;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.CachedBodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.analyze.JsConfiguration;
import org.jetbrains.k2js.config.Config;

public final class AnalyzerFacadeForJS {
    private AnalyzerFacadeForJS() {
    }

    @NotNull
    public static BindingContext analyzeFilesAndCheckErrors(@NotNull List<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFilesAndCheckErrors"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFilesAndCheckErrors"));
        }
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        AnalyzerFacadeForJS.checkForErrors(Config.withJsLibAdded(files, config), bindingContext);
        BindingContext bindingContext2 = bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFilesAndCheckErrors"));
        }
        return bindingContext2;
    }

    @NotNull
    public static BindingContext analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        return bindingContext;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJS.analyzeFiles(files, filesToAnalyzeCompletely, config, false);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        return analyzeExhaust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config, boolean storeContextForBodiesResolve) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        Project project = config.getProject();
        ModuleDescriptorImpl owner = AnalyzerFacadeForJS.createJsModule("<module>");
        Predicate<PsiFile> completely = Predicates.and(AnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(completely, false, false, Collections.<AnalyzerScriptParameter>emptyList());
        BindingContext libraryBindingContext = config.getLibraryBindingContext();
        BindingTrace trace = libraryBindingContext == null ? new ObservableBindingTrace(new BindingTraceContext()) : new DelegatingBindingTrace(libraryBindingContext, "trace for analyzing library in js");
        owner.setModuleConfiguration(new JsConfiguration(libraryBindingContext));
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, trace, owner);
        Collection<JetFile> allFiles = libraryBindingContext != null ? files : Config.withJsLibAdded(files, config);
        injector.getTopDownAnalyzer().analyzeFiles(allFiles, Collections.<AnalyzerScriptParameter>emptyList());
        CachedBodiesResolveContext bodiesResolveContext = storeContextForBodiesResolve ? new CachedBodiesResolveContext(injector.getTopDownAnalysisContext()) : null;
        AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), bodiesResolveContext, owner);
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeFiles"));
        }
        return analyzeExhaust2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static AnalyzeExhaust analyzeBodiesInFiles(@NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config, @NotNull BindingTrace traceContext, @NotNull BodiesResolveContext bodiesResolveContext, @NotNull ModuleDescriptor module) {
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        Predicate<PsiFile> completely = Predicates.and(AnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForEverything.analyzeBodiesInFilesWithJavaIntegration(config.getProject(), Collections.<AnalyzerScriptParameter>emptyList(), completely, traceContext, bodiesResolveContext, module);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "analyzeBodiesInFiles"));
        }
        return analyzeExhaust;
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    private static Predicate<PsiFile> notLibFiles(final @NotNull List<JetFile> jsLibFiles) {
        if (jsLibFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLibFiles", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "notLibFiles"));
        }
        Predicate<PsiFile> predicate = new Predicate<PsiFile>(){

            @Override
            public boolean apply(@Nullable PsiFile file) {
                assert (file instanceof JetFile);
                boolean notLibFile = !jsLibFiles.contains(file);
                return notLibFile;
            }
        };
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "notLibFiles"));
        }
        return predicate;
    }

    @NotNull
    public static ResolveSession getLazyResolveSession(Collection<JetFile> files, Config config) {
        LockBasedLazyResolveStorageManager storageManager = new LockBasedLazyResolveStorageManager();
        FileBasedDeclarationProviderFactory declarationProviderFactory = new FileBasedDeclarationProviderFactory(storageManager, Config.withJsLibAdded(files, config), Predicates.<FqName>alwaysFalse());
        ModuleDescriptorImpl lazyModule = AnalyzerFacadeForJS.createJsModule("<lazy module>");
        lazyModule.setModuleConfiguration(new JsConfiguration(null));
        ResolveSession resolveSession = new ResolveSession(config.getProject(), storageManager, lazyModule, declarationProviderFactory);
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "getLazyResolveSession"));
        }
        return resolveSession;
    }

    @NotNull
    private static ModuleDescriptorImpl createJsModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "createJsModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), JsConfiguration.DEFAULT_IMPORT_PATHS, PlatformToKotlinClassMap.EMPTY);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/AnalyzerFacadeForJS", "createJsModule"));
        }
        return moduleDescriptorImpl;
    }
}

