/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DefineInvocation;
import org.jetbrains.k2js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final NamespaceDescriptor descriptor;
    private final FileDeclarationVisitor visitor;
    private final NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> definitionPlace;

    NamespaceTranslator(final @NotNull NamespaceDescriptor descriptor, final @NotNull Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (descriptorToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.visitor = new FileDeclarationVisitor(this.context());
        this.definitionPlace = new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

            @Override
            @NotNull
            public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                DefineInvocation defineInvocation = (DefineInvocation)descriptorToDefineInvocation.get(descriptor);
                if (defineInvocation == null) {
                    defineInvocation = NamespaceTranslator.this.createDefinitionPlace(null, descriptorToDefineInvocation);
                }
                Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> trinity = LiteralFunctionTranslator.createPlace(defineInvocation.getMembers(), NamespaceTranslator.this.context().getQualifiedReference(descriptor));
                if (trinity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$1", "compute"));
                }
                return trinity;
            }
        };
    }

    public void translate(JetFile file) {
        this.context().literalFunctionTranslator().setDefinitionPlace(this.definitionPlace);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
        this.context().literalFunctionTranslator().setDefinitionPlace(null);
    }

    private DefineInvocation createDefinitionPlace(@Nullable JsExpression initializer, Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        DefineInvocation place = DefineInvocation.createDefineInvocation(this.descriptor, initializer, new JsObjectLiteral(this.visitor.getResult(), true), this.context());
        descriptorToDefineInvocation.put(this.descriptor, place);
        this.addToParent((NamespaceDescriptor)this.descriptor.getContainingDeclaration(), this.getEntry(this.descriptor, place), descriptorToDefineInvocation);
        return place;
    }

    public void add(@NotNull Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        if (descriptorToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "add"));
        }
        JsFunction initializer = this.visitor.computeInitializer();
        DefineInvocation defineInvocation = descriptorToDefineInvocation.get(this.descriptor);
        if (defineInvocation == null) {
            if (initializer != null || !this.visitor.getResult().isEmpty()) {
                this.createDefinitionPlace(initializer, descriptorToDefineInvocation);
            }
        } else {
            List<JsPropertyInitializer> listFromPlace;
            if (initializer != null) {
                assert (defineInvocation.getInitializer() == JsLiteral.NULL);
                defineInvocation.setInitializer(initializer);
            }
            if ((listFromPlace = defineInvocation.getMembers()) != this.visitor.getResult()) {
                listFromPlace.addAll(this.visitor.getResult());
            }
        }
    }

    private JsPropertyInitializer getEntry(@NotNull NamespaceDescriptor descriptor, DefineInvocation defineInvocation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "getEntry"));
        }
        return new JsPropertyInitializer(this.context().getNameForDescriptor(descriptor).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation.asList()));
    }

    private boolean addEntryIfParentExists(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, DefineInvocation> descriptorToDeclarationPlace) {
        DefineInvocation parentDefineInvocation = descriptorToDeclarationPlace.get(parentDescriptor);
        if (parentDefineInvocation != null) {
            parentDefineInvocation.getMembers().add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation) {
        while (!this.addEntryIfParentExists(parentDescriptor, entry, descriptorToDefineInvocation)) {
            JsObjectLiteral members = new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true);
            DefineInvocation defineInvocation = DefineInvocation.createDefineInvocation(parentDescriptor, null, members, this.context());
            entry = this.getEntry(parentDescriptor, defineInvocation);
            descriptorToDefineInvocation.put(parentDescriptor, defineInvocation);
            parentDescriptor = (NamespaceDescriptor)parentDescriptor.getContainingDeclaration();
        }
    }
}

