/*
 * Copyright 2010-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.lang.descriptors;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public interface ReceiverParameterDescriptor extends DeclarationDescriptor {

    // This field exists for better readability of the client code
    @Nullable
    ReceiverParameterDescriptor NO_RECEIVER_PARAMETER = null;

    @NotNull
    JetType getType();

    @NotNull
    ReceiverValue getValue();

    @Override
    @NotNull
    DeclarationDescriptor getContainingDeclaration();

    @Nullable
    @Override
    ReceiverParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor);
}
