/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import gnu.trove.THashMap;
import java.util.Map;

public class ResolveState {
    private static final ResolveState ourInitialState = new ResolveState();

    public static ResolveState initial() {
        return ourInitialState;
    }

    public <T> ResolveState put(Key<T> key, T value) {
        return new OneElementResolveState(key, value);
    }

    public <T> T get(Key<T> key) {
        if (key instanceof KeyWithDefaultValue) {
            return ((KeyWithDefaultValue)key).getDefaultValue();
        }
        return null;
    }

    private static class ManyElementResolveState
    extends ResolveState {
        private final Map<Object, Object> myValues = new THashMap<Object, Object>();

        ManyElementResolveState(ManyElementResolveState parent, Key key, Object value) {
            this.myValues.putAll(parent.myValues);
            this.myValues.put(key, value);
        }

        ManyElementResolveState(TwoElementResolveState twoState, Key key, Object value) {
            this.myValues.put(twoState.myKey1, twoState.myValue1);
            this.myValues.put(twoState.myKey2, twoState.myValue2);
            this.myValues.put(key, value);
        }

        @Override
        public <T> ResolveState put(Key<T> key, T value) {
            return new ManyElementResolveState(this, key, value);
        }

        @Override
        public <T> T get(Key<T> key) {
            Object value = this.myValues.get(key);
            if (value == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }

    private static class TwoElementResolveState
    extends ResolveState {
        final Key myKey1;
        final Object myValue1;
        final Key myKey2;
        final Object myValue2;

        TwoElementResolveState(Key key1, Object value1, Key key2, Object value2) {
            this.myKey1 = key1;
            this.myValue1 = value1;
            this.myKey2 = key2;
            this.myValue2 = value2;
        }

        @Override
        public <T> ResolveState put(Key<T> key, T value) {
            if (this.myKey1.equals(key)) {
                return new TwoElementResolveState(key, value, this.myKey2, this.myValue2);
            }
            if (this.myKey2.equals(key)) {
                return new TwoElementResolveState(this.myKey1, this.myValue1, key, value);
            }
            return new ManyElementResolveState(this, key, value);
        }

        @Override
        public <T> T get(Key<T> key) {
            Object value = this.myKey1.equals(key) ? this.myValue1 : (this.myKey2.equals(key) ? this.myValue2 : null);
            if (value == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }

    private static class OneElementResolveState
    extends ResolveState {
        final Key myKey;
        final Object myValue;

        OneElementResolveState(Key key, Object value) {
            this.myKey = key;
            this.myValue = value;
        }

        @Override
        public <T> ResolveState put(Key<T> key, T value) {
            if (this.myKey.equals(key)) {
                return new OneElementResolveState(key, value);
            }
            return new TwoElementResolveState(this.myKey, this.myValue, key, value);
        }

        @Override
        public <T> T get(Key<T> key) {
            Object value;
            Object object2 = value = this.myKey.equals(key) ? this.myValue : null;
            if (value == null && key instanceof KeyWithDefaultValue) {
                return ((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }
}

