/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = ContainerUtil.createLockFreeCopyOnWriteList();

    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "registerExecutor"));
        }
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "unregisterExecutor"));
        }
        this.myExecutors.remove(executor);
    }

    @NotNull
    public final Query<Result> createQuery(@NotNull Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "createQuery"));
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery(parameters, this.getExecutors());
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "createQuery"));
        }
        return executorsQuery;
    }

    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list2 = this.myExecutors;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "getExecutors"));
        }
        return list2;
    }

    public boolean hasAnyExecutors() {
        return !this.getExecutors().isEmpty();
    }

    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return new UniqueResultsQuery(this.createQuery(parameters));
    }

    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters, @NotNull TObjectHashingStrategy<Result> hashingStrategy) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return new UniqueResultsQuery<Result, Result>(this.createQuery(parameters), hashingStrategy);
    }

    public final <T> Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters, @NotNull TObjectHashingStrategy<T> hashingStrategy, @NotNull Function<Result, T> mapper) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return new UniqueResultsQuery<Result, T>(this.createQuery(parameters), hashingStrategy, mapper);
    }
}

