/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.DoubleIterator;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.ArrayIterator;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$5;
import kotlin.KotlinPackage$sortBy$sortBy$5;
import kotlin.KotlinPackage-IterablesSpecial-c146b6a1;
import kotlin.KotlinPackage-Maps-b54c5e2;
import kotlin.KotlinPackage-OrderingJVM-7b90e8c8;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinPackageFragment(abiVersion=11)
public final class KotlinPackage-_DoubleArrays-dc4fe457 {
    public static final boolean all(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            if (predicate.invoke((Double)element).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final boolean any(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            if (!predicate.invoke((Double)element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final void appendString(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="buffer") @NotNull Appendable buffer, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (Double.valueOf(element) != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(double[] dArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_DoubleArrays-dc4fe457.appendString(dArray, appendable, string, string2, string3, n, string4);
    }

    public static final int count(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            double element = $receiver[i];
            if (predicate.invoke((Double)element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @NotNull
    public static final List<Double> drop(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_DoubleArrays-dc4fe457.dropWhile($receiver, KotlinPackage-IterablesSpecial-c146b6a1.countTo(n));
    }

    @NotNull
    public static final List<Double> dropWhile(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @NotNull
    public static final <L extends List<? super Double>> L dropWhileTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull L result, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            double element = $receiver[i];
            if (!(start != 0 ? predicate.invoke((Double)element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final List<Double> filter(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final List<Double> filterNot(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <C extends Collection<? super Double>> C filterNotTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            Object object2 = predicate.invoke((Double)element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final <C extends Collection<? super Double>> C filterTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            Object object2 = predicate.invoke((Double)element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @Nullable
    public static final Double find(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            if (!predicate.invoke((Double)element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static final <R> List<R> flatMap(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super Double, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @NotNull
    public static final <R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super Double, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            Iterable<R> list2 = transform.invoke(element);
            for (R r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @Nullable
    public static final <R> R fold(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="initial") @Nullable R initial, @JetValueParameter(name="operation") @NotNull Function2<? super R, ? super Double, ? extends R> operation) {
        R answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @Nullable
    public static final <R> R foldRight(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="initial") @Nullable R initial, @JetValueParameter(name="operation") @NotNull Function2<? super Double, ? super R, ? extends R> operation) {
        R r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke($receiver[index--], r);
        }
        return r;
    }

    @NotNull
    public static final void forEach(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super Double, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            operation.invoke((Double)element);
        }
    }

    @NotNull
    public static final <K> Map<K, List<? extends Double>> groupBy(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="toKey") @NotNull Function1<? super Double, ? extends K> toKey) {
        return KotlinPackage-_DoubleArrays-dc4fe457.groupByTo($receiver, new HashMap(), toKey);
    }

    @NotNull
    public static final <K> Map<K, List<Double>> groupByTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull Map<K, List<Double>> result, @JetValueParameter(name="toKey") @NotNull Function1<? super Double, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            K key = toKey.invoke(element);
            List<Double> list2 = KotlinPackage-Maps-b54c5e2.getOrPut(result, key, KotlinPackage$groupByTo$list$5.instance$);
            list2.add(element);
        }
        return result;
    }

    @NotNull
    public static final String makeString(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_DoubleArrays-dc4fe457.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(double[] dArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_DoubleArrays-dc4fe457.makeString(dArray, string, string2, string3, n, string4);
    }

    @NotNull
    public static final <R> List<R> map(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super Double, ? extends R> transform) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @NotNull
    public static final <R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super Double, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            double item = $receiver[i];
            result.add(transform.invoke(item));
        }
        return result;
    }

    @NotNull
    public static final Pair<List<? extends Double>, List<? extends Double>> partition(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        ArrayList<Double> first = new ArrayList<Double>();
        ArrayList<Double> second = new ArrayList<Double>();
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            boolean bl = predicate.invoke((Double)element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends Double>, List<? extends Double>>(first, second);
    }

    @NotNull
    public static final List<Double> plus(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="collection") @NotNull Iterable<? extends Double> collection) {
        return KotlinPackage-_DoubleArrays-dc4fe457.plus($receiver, collection.iterator());
    }

    @NotNull
    public static final List<Double> plus(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="element") double element) {
        ArrayList<Double> answer = new ArrayList<Double>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @NotNull
    public static final List<Double> plus(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="iterator") @NotNull Iterator<? extends Double> iterator2) {
        ArrayList<Double> answer = new ArrayList<Double>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)answer);
        Iterator<? extends Double> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            double element = ((Number)iterator3.next()).doubleValue();
            answer.add(element);
        }
        return answer;
    }

    public static final double reduce(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super Double, ? super Double, ? extends Double> operation) {
        DoubleIterator iterator2 = ArrayIterator.iterator($receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        double result = iterator2.nextDouble();
        while (iterator2.hasNext()) {
            result = ((Number)operation.invoke((Double)result, (Double)iterator2.nextDouble())).doubleValue();
        }
        return result;
    }

    public static final double reduceRight(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super Double, ? super Double, ? extends Double> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        double r = $receiver[index--];
        while (index >= 0) {
            r = ((Number)operation.invoke((Double)$receiver[index--], (Double)r)).doubleValue();
        }
        return r;
    }

    @NotNull
    public static final List<Double> reverse(@JetValueParameter(name="$receiver") double[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @NotNull
    public static final <R extends Comparable<? super R>> List<Double> sortBy(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="f") @NotNull Function1<? super Double, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-7b90e8c8.comparator(new KotlinPackage$sortBy$sortBy$5(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @NotNull
    public static final List<Double> take(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_DoubleArrays-dc4fe457.takeWhile($receiver, KotlinPackage-IterablesSpecial-c146b6a1.countTo(n));
    }

    @NotNull
    public static final List<Double> takeWhile(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <C extends Collection<? super Double>> C takeWhileTo(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super Double, ? extends Boolean> predicate) {
        double element;
        for (int i = 0; i < $receiver.length && predicate.invoke((Double)(element = $receiver[i])).booleanValue(); ++i) {
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <C extends Collection<? super Double>> C toCollection(@JetValueParameter(name="$receiver") double[] $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            double element = $receiver[i];
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final LinkedList<Double> toLinkedList(@JetValueParameter(name="$receiver") double[] $receiver) {
        return (LinkedList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new LinkedList());
    }

    @NotNull
    public static final List<Double> toList(@JetValueParameter(name="$receiver") double[] $receiver) {
        return (ArrayList)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final Set<Double> toSet(@JetValueParameter(name="$receiver") double[] $receiver) {
        return (LinkedHashSet)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @NotNull
    public static final SortedSet<Double> toSortedSet(@JetValueParameter(name="$receiver") double[] $receiver) {
        return (TreeSet)KotlinPackage-_DoubleArrays-dc4fe457.toCollection($receiver, (Collection)new TreeSet());
    }

    @NotNull
    public static final Iterator<Pair<? extends Integer, ? extends Double>> withIndices(@JetValueParameter(name="$receiver") double[] $receiver) {
        return new IndexIterator(ArrayIterator.iterator($receiver));
    }
}

