/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.TypeCastException;
import jet.Unit;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$8;
import kotlin.KotlinPackage$sortBy$sortBy$8;
import kotlin.KotlinPackage-IterablesSpecial-c146b6a1;
import kotlin.KotlinPackage-Maps-b54c5e2;
import kotlin.KotlinPackage-OrderingJVM-7b90e8c8;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinPackageFragment(abiVersion=11)
public final class KotlinPackage-_Iterables-6cb3d98b {
    public static final <T> boolean all(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (predicate.invoke(element).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final <T> boolean any(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T> void appendString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="buffer") @NotNull Appendable buffer, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (T element : $receiver) {
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(Iterable iterable, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_Iterables-6cb3d98b.appendString(iterable, appendable, string, string2, string3, n, string4);
    }

    public static final <T> int count(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        for (T element : $receiver) {
            Object object2;
            if (predicate.invoke(element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @NotNull
    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_Iterables-6cb3d98b.dropWhile($receiver, KotlinPackage-IterablesSpecial-c146b6a1.countTo(n));
    }

    @NotNull
    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    @NotNull
    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull L result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        for (T element : $receiver) {
            Object object2;
            if (!(start != 0 ? predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final <T> List<T> filter(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <T> List<T> filterNot(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <T> List<T> filterNotNull(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.filterNotNullTo($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @Nullable
    public static final <T> T find(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static final <T, R> List<R> flatMap(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @NotNull
    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        for (T element : $receiver) {
            Iterable<R> list2 = transform.invoke(element);
            for (R r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    @Nullable
    public static final <T, R> R fold(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="initial") @Nullable R initial, @JetValueParameter(name="operation") @NotNull Function2<? super R, ? super T, ? extends R> operation) {
        R answer = initial;
        for (T element : $receiver) {
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @NotNull
    public static final <T> void forEach(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super T, ? extends Unit> operation) {
        for (T element : $receiver) {
            operation.invoke(element);
        }
    }

    @NotNull
    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        return KotlinPackage-_Iterables-6cb3d98b.groupByTo($receiver, new HashMap(), toKey);
    }

    @NotNull
    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull Map<K, List<T>> result, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        for (T element : $receiver) {
            K key = toKey.invoke(element);
            List<T> list2 = KotlinPackage-Maps-b54c5e2.getOrPut(result, key, KotlinPackage$groupByTo$list$8.instance$);
            list2.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> String makeString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_Iterables-6cb3d98b.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(Iterable iterable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_Iterables-6cb3d98b.makeString(iterable, string, string2, string3, n, string4);
    }

    @NotNull
    public static final <T, R> List<R> map(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    @NotNull
    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        for (T item : $receiver) {
            result.add(transform.invoke(item));
        }
        return result;
    }

    @NotNull
    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (T element : $receiver) {
            boolean bl = predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="collection") @NotNull Iterable<? extends T> collection) {
        return KotlinPackage-_Iterables-6cb3d98b.plus($receiver, collection.iterator());
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="element") @Nullable T element) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="iterator") @NotNull Iterator<? extends T> iterator2) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)answer);
        Iterator<T> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            T element = iterator3.next();
            answer.add(element);
        }
        return answer;
    }

    @Nullable
    public static final <T> T reduce(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    @NotNull
    public static final <T> Iterable<T> requireNoNulls(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element != null) {
                bl = false;
            }
            if (!bl) continue;
            throw (Throwable)new IllegalArgumentException("null element found in " + $receiver);
        }
        Iterable<T> iterable = $receiver;
        if (iterable == null) {
            throw new TypeCastException("jet.Iterable<T?> cannot be cast to jet.Iterable<T>");
        }
        return iterable;
    }

    @NotNull
    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    @NotNull
    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-7b90e8c8.comparator(new KotlinPackage$sortBy$sortBy$8(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @NotNull
    public static final <T> List<T> take(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_Iterables-6cb3d98b.takeWhile($receiver, KotlinPackage-IterablesSpecial-c146b6a1.countTo(n));
    }

    @NotNull
    public static final <T> List<T> takeWhile(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) break;
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (T element : $receiver) {
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new LinkedList());
    }

    @NotNull
    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @NotNull
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (TreeSet)KotlinPackage-_Iterables-6cb3d98b.toCollection($receiver, (Collection)new TreeSet());
    }

    @NotNull
    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return new IndexIterator<T>($receiver.iterator());
    }
}

