/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorForObjectImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.storage.StorageManager;

public class DescriptorDeserializer {
    private final DeclarationDescriptor containingDeclaration;
    private final NameResolver nameResolver;
    private final TypeDeserializer typeDeserializer;
    private final AnnotationDeserializer annotationDeserializer;
    private final StorageManager storageManager;

    @NotNull
    public static DescriptorDeserializer create(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull AnnotationDeserializer annotationDeserializer) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFinder", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        DescriptorDeserializer descriptorDeserializer = new DescriptorDeserializer(storageManager, new TypeDeserializer(storageManager, null, nameResolver, descriptorFinder, "Deserializer for " + containingDeclaration.getName(), TypeDeserializer.TypeParameterResolver.NONE), containingDeclaration, nameResolver, annotationDeserializer);
        if (descriptorDeserializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        return descriptorDeserializer;
    }

    @NotNull
    public static DescriptorDeserializer create(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer annotationDeserializer) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        DescriptorDeserializer descriptorDeserializer = new DescriptorDeserializer(storageManager, typeDeserializer, containingDeclaration, nameResolver, annotationDeserializer);
        if (descriptorDeserializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "create"));
        }
        return descriptorDeserializer;
    }

    private DescriptorDeserializer(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer annotationDeserializer) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "<init>"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "<init>"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "<init>"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "<init>"));
        }
        this.storageManager = storageManager;
        this.typeDeserializer = typeDeserializer;
        this.containingDeclaration = containingDeclaration;
        this.nameResolver = nameResolver;
        this.annotationDeserializer = annotationDeserializer;
    }

    @NotNull
    public TypeDeserializer getTypeDeserializer() {
        TypeDeserializer typeDeserializer = this.typeDeserializer;
        if (typeDeserializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getTypeDeserializer"));
        }
        return typeDeserializer;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public DescriptorDeserializer createChildDeserializer(@NotNull DeclarationDescriptor descriptor, final @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, final @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createChildDeserializer"));
        }
        if (typeParameterProtos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterProtos", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createChildDeserializer"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createChildDeserializer"));
        }
        TypeDeserializer childTypeDeserializer = new TypeDeserializer(this.storageManager, this.typeDeserializer, "Child deserializer for " + descriptor.getName(), new TypeDeserializer.TypeParameterResolver(){

            @Override
            @NotNull
            public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer typeDeserializer) {
                if (typeDeserializer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer$1", "getTypeParameters"));
                }
                List<DeserializedTypeParameterDescriptor> descriptors = DescriptorDeserializer.this.typeParameters(typeParameterProtos, typeDeserializer);
                typeParameters.addAll(descriptors);
                List<DeserializedTypeParameterDescriptor> list2 = descriptors;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer$1", "getTypeParameters"));
                }
                return list2;
            }
        });
        DescriptorDeserializer descriptorDeserializer = DescriptorDeserializer.create(this.storageManager, childTypeDeserializer, descriptor, this.nameResolver, this.annotationDeserializer);
        if (descriptorDeserializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createChildDeserializer"));
        }
        return descriptorDeserializer;
    }

    @NotNull
    public CallableMemberDescriptor loadCallable(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadCallable"));
        }
        ProtoBuf.Callable.CallableKind callableKind = Flags.CALLABLE_KIND.get(proto.getFlags());
        switch (callableKind) {
            case FUN: {
                CallableMemberDescriptor callableMemberDescriptor = this.loadFunction(proto);
                if (callableMemberDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadCallable"));
                }
                return callableMemberDescriptor;
            }
            case VAL: 
            case VAR: 
            case OBJECT_PROPERTY: {
                PropertyDescriptor propertyDescriptor = this.loadProperty(proto);
                if (propertyDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadCallable"));
                }
                return propertyDescriptor;
            }
            case CONSTRUCTOR: {
                CallableMemberDescriptor callableMemberDescriptor = this.loadConstructor(proto);
                if (callableMemberDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadCallable"));
                }
                return callableMemberDescriptor;
            }
        }
        throw new IllegalArgumentException("Unsupported callable kind: " + callableKind);
    }

    @NotNull
    private PropertyDescriptor loadProperty(@NotNull ProtoBuf.Callable proto) {
        boolean isNotDefault;
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadProperty"));
        }
        PropertyDescriptorImpl property2 = this.createPropertyDescriptor(proto);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(property2, proto.getTypeParameterList(), typeParameters);
        property2.setType(local.typeDeserializer.type(proto.getReturnType()), typeParameters, this.getExpectedThisObject(), local.typeDeserializer.typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null));
        PropertyGetterDescriptorImpl getter = null;
        PropertySetterDescriptorImpl setter = null;
        if (Flags.HAS_GETTER.get(proto.getFlags()).booleanValue()) {
            int getterFlags = proto.getGetterFlags();
            boolean bl = isNotDefault = proto.hasGetterFlags() && Flags.IS_NOT_DEFAULT.get(getterFlags) != false;
            getter = isNotDefault ? new PropertyGetterDescriptorImpl(property2, this.getAnnotations(proto, getterFlags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY_GETTER), DescriptorDeserializer.modality(Flags.MODALITY.get(getterFlags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(getterFlags)), isNotDefault, !isNotDefault, property2.getKind()) : DescriptorFactory.createDefaultGetter(property2);
            getter.initialize(property2.getReturnType());
        }
        if (Flags.HAS_SETTER.get(proto.getFlags()).booleanValue()) {
            int setterFlags = proto.getSetterFlags();
            boolean bl = isNotDefault = proto.hasSetterFlags() && Flags.IS_NOT_DEFAULT.get(setterFlags) != false;
            if (isNotDefault) {
                setter = new PropertySetterDescriptorImpl(property2, this.getAnnotations(proto, setterFlags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY_SETTER), DescriptorDeserializer.modality(Flags.MODALITY.get(setterFlags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(setterFlags)), isNotDefault, !isNotDefault, property2.getKind());
                DescriptorDeserializer setterLocal = local.createChildDeserializer(setter, Collections.<ProtoBuf.TypeParameter>emptyList(), Collections.<TypeParameterDescriptor>emptyList());
                List<ValueParameterDescriptor> valueParameters = setterLocal.valueParameters(proto, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY_SETTER);
                assert (valueParameters.size() == 1) : "Property setter should have a single value parameter: " + setter;
                setter.initialize(valueParameters.get(0));
            } else {
                setter = DescriptorFactory.createDefaultSetter(property2);
            }
        }
        property2.initialize(getter, setter);
        PropertyDescriptorImpl propertyDescriptorImpl = property2;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadProperty"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    private PropertyDescriptorImpl createPropertyDescriptor(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createPropertyDescriptor"));
        }
        int flags = proto.getFlags();
        Name name = this.nameResolver.getName(proto.getName());
        List<AnnotationDescriptor> annotations = this.getAnnotations(proto, flags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY);
        Visibility visibility = DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags));
        ProtoBuf.Callable.CallableKind callableKind = Flags.CALLABLE_KIND.get(flags);
        if (callableKind == ProtoBuf.Callable.CallableKind.OBJECT_PROPERTY) {
            FqNameUnsafe fqName = DescriptorUtils.getFQName(this.containingDeclaration).child(name);
            ClassId objectId = ClassId.fromFqNameAndContainingDeclaration(fqName, (ClassOrNamespaceDescriptor)this.containingDeclaration);
            ClassDescriptor objectClass = this.typeDeserializer.getDescriptorFinder().findClass(objectId);
            if (objectClass == null) {
                objectClass = ErrorUtils.createErrorClass(objectId.asSingleFqName().asString());
            }
            PropertyDescriptorForObjectImpl propertyDescriptorForObjectImpl = new PropertyDescriptorForObjectImpl(this.containingDeclaration, annotations, visibility, name, objectClass);
            if (propertyDescriptorForObjectImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createPropertyDescriptor"));
            }
            return propertyDescriptorForObjectImpl;
        }
        PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(this.containingDeclaration, annotations, DescriptorDeserializer.modality(Flags.MODALITY.get(flags)), visibility, callableKind == ProtoBuf.Callable.CallableKind.VAR, name, DescriptorDeserializer.memberKind(Flags.MEMBER_KIND.get(flags)));
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "createPropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    private CallableMemberDescriptor loadFunction(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadFunction"));
        }
        int flags = proto.getFlags();
        SimpleFunctionDescriptorImpl function = new SimpleFunctionDescriptorImpl(this.containingDeclaration, this.getAnnotations(proto, proto.getFlags(), AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), this.nameResolver.getName(proto.getName()), DescriptorDeserializer.memberKind(Flags.MEMBER_KIND.get(flags)));
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(function, proto.getTypeParameterList(), typeParameters);
        function.initialize(local.typeDeserializer.typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null), this.getExpectedThisObject(), typeParameters, local.valueParameters(proto, AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), local.typeDeserializer.type(proto.getReturnType()), DescriptorDeserializer.modality(Flags.MODALITY.get(flags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags)), Flags.INLINE.get(flags));
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = function;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadFunction"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @Nullable
    private ReceiverParameterDescriptor getExpectedThisObject() {
        return this.containingDeclaration instanceof ClassDescriptor ? ((ClassDescriptor)this.containingDeclaration).getThisAsReceiverParameter() : null;
    }

    @NotNull
    private CallableMemberDescriptor loadConstructor(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadConstructor"));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)this.containingDeclaration;
        ConstructorDescriptorImpl descriptor = new ConstructorDescriptorImpl(classDescriptor, this.getAnnotations(proto, proto.getFlags(), AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), true);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(descriptor, Collections.<ProtoBuf.TypeParameter>emptyList(), typeParameters);
        descriptor.initialize(classDescriptor.getTypeConstructor().getParameters(), local.valueParameters(proto, AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(proto.getFlags())), DescriptorUtils.isConstructorOfStaticNestedClass(descriptor));
        descriptor.setReturnType(local.typeDeserializer.type(proto.getReturnType()));
        ConstructorDescriptorImpl constructorDescriptorImpl = descriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "loadConstructor"));
        }
        return constructorDescriptorImpl;
    }

    @NotNull
    private List<AnnotationDescriptor> getAnnotations(@NotNull ProtoBuf.Callable proto, int flags, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        assert (this.containingDeclaration instanceof ClassOrNamespaceDescriptor) : "Only members in classes or namespaces should be serialized: " + this.containingDeclaration;
        List<AnnotationDescriptor> list2 = Flags.HAS_ANNOTATIONS.get(flags) != false ? this.annotationDeserializer.loadCallableAnnotations((ClassOrNamespaceDescriptor)this.containingDeclaration, proto, this.nameResolver, kind) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        return list2;
    }

    private static CallableMemberDescriptor.Kind memberKind(ProtoBuf.Callable.MemberKind memberKind) {
        switch (memberKind) {
            case DECLARATION: {
                return CallableMemberDescriptor.Kind.DECLARATION;
            }
            case FAKE_OVERRIDE: {
                return CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
            case DELEGATION: {
                return CallableMemberDescriptor.Kind.DELEGATION;
            }
            case SYNTHESIZED: {
                return CallableMemberDescriptor.Kind.SYNTHESIZED;
            }
        }
        throw new IllegalArgumentException("Unknown member kind: " + memberKind);
    }

    @NotNull
    public static Modality modality(@NotNull ProtoBuf.Modality modality) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "modality"));
        }
        switch (modality) {
            case FINAL: {
                Modality modality2 = Modality.FINAL;
                if (modality2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "modality"));
                }
                return modality2;
            }
            case OPEN: {
                Modality modality3 = Modality.OPEN;
                if (modality3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "modality"));
                }
                return modality3;
            }
            case ABSTRACT: {
                Modality modality4 = Modality.ABSTRACT;
                if (modality4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "modality"));
                }
                return modality4;
            }
        }
        throw new IllegalArgumentException("Unknown modality: " + modality);
    }

    @NotNull
    public static Visibility visibility(@NotNull ProtoBuf.Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "visibility"));
        }
        switch (visibility) {
            case INTERNAL: {
                Visibility visibility2 = Visibilities.INTERNAL;
                if (visibility2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "visibility"));
                }
                return visibility2;
            }
            case PRIVATE: {
                Visibility visibility3 = Visibilities.PRIVATE;
                if (visibility3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "visibility"));
                }
                return visibility3;
            }
            case PROTECTED: {
                Visibility visibility4 = Visibilities.PROTECTED;
                if (visibility4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "visibility"));
                }
                return visibility4;
            }
            case PUBLIC: {
                Visibility visibility5 = Visibilities.PUBLIC;
                if (visibility5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "visibility"));
                }
                return visibility5;
            }
            case EXTRA: {
                throw new UnsupportedOperationException("Extra visibilities are not supported yet");
            }
        }
        throw new IllegalArgumentException("Unknown visibility: " + visibility);
    }

    @NotNull
    public static ClassKind classKind(@NotNull ProtoBuf.Class.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
        }
        switch (kind) {
            case CLASS: {
                ClassKind classKind = ClassKind.CLASS;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case TRAIT: {
                ClassKind classKind = ClassKind.TRAIT;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case ENUM_CLASS: {
                ClassKind classKind = ClassKind.ENUM_CLASS;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case ENUM_ENTRY: {
                ClassKind classKind = ClassKind.ENUM_ENTRY;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case ANNOTATION_CLASS: {
                ClassKind classKind = ClassKind.ANNOTATION_CLASS;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case OBJECT: {
                ClassKind classKind = ClassKind.OBJECT;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
            case CLASS_OBJECT: {
                ClassKind classKind = ClassKind.CLASS_OBJECT;
                if (classKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "classKind"));
                }
                return classKind;
            }
        }
        throw new IllegalArgumentException("Unknown class kind: " + kind);
    }

    @NotNull
    public List<DeserializedTypeParameterDescriptor> typeParameters(@NotNull List<ProtoBuf.TypeParameter> protos, @NotNull TypeDeserializer typeDeserializer) {
        if (protos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protos", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "typeParameters"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "typeParameters"));
        }
        ArrayList<DeserializedTypeParameterDescriptor> result = new ArrayList<DeserializedTypeParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.TypeParameter proto = protos.get(i);
            DeserializedTypeParameterDescriptor descriptor = new DeserializedTypeParameterDescriptor(this.storageManager, typeDeserializer, proto, this.containingDeclaration, this.nameResolver.getName(proto.getName()), DescriptorDeserializer.variance(proto.getVariance()), proto.getReified(), i);
            result.add(descriptor);
        }
        ArrayList<DeserializedTypeParameterDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "typeParameters"));
        }
        return arrayList;
    }

    private static Variance variance(ProtoBuf.TypeParameter.Variance proto) {
        switch (proto) {
            case IN: {
                return Variance.IN_VARIANCE;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case INV: {
                return Variance.INVARIANT;
            }
        }
        throw new IllegalStateException("Unknown projection: " + proto);
    }

    @NotNull
    private List<ValueParameterDescriptor> valueParameters(@NotNull ProtoBuf.Callable callable2, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "valueParameters"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "valueParameters"));
        }
        DeclarationDescriptor containerOfCallable = this.containingDeclaration.getContainingDeclaration();
        assert (containerOfCallable instanceof ClassOrNamespaceDescriptor) : "Only members in classes or namespaces should be serialized: " + containerOfCallable;
        ClassOrNamespaceDescriptor classOrNamespace = (ClassOrNamespaceDescriptor)containerOfCallable;
        List<ProtoBuf.Callable.ValueParameter> protos = callable2.getValueParameterList();
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.Callable.ValueParameter proto = protos.get(i);
            result.add(new ValueParameterDescriptorImpl(this.containingDeclaration, i, this.getAnnotations(classOrNamespace, callable2, kind, proto), this.nameResolver.getName(proto.getName()), this.typeDeserializer.type(proto.getType()), Flags.DECLARES_DEFAULT_VALUE.get(proto.getFlags()), this.typeDeserializer.typeOrNull(proto.hasVarargElementType() ? proto.getVarargElementType() : null)));
        }
        ArrayList<ValueParameterDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "valueParameters"));
        }
        return arrayList;
    }

    @NotNull
    private List<AnnotationDescriptor> getAnnotations(@NotNull ClassOrNamespaceDescriptor classOrNamespace, @NotNull ProtoBuf.Callable callable2, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter valueParameter) {
        if (classOrNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrNamespace", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        List<AnnotationDescriptor> list2 = Flags.HAS_ANNOTATIONS.get(valueParameter.getFlags()) != false ? this.annotationDeserializer.loadValueParameterAnnotations(classOrNamespace, callable2, this.nameResolver, kind, valueParameter) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorDeserializer", "getAnnotations"));
        }
        return list2;
    }
}

