/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.lang.psi.JetContainerNode;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public abstract class JetExpressionImpl
extends JetElementImpl
implements JetExpression {
    public JetExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetExpressionImpl", "accept"));
        }
        visitor.visitExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetExpressionImpl", "accept"));
        }
        return visitor.visitExpression(this, data2);
    }

    protected JetExpression findExpressionUnder(JetNodeType type) {
        JetContainerNode containerNode = (JetContainerNode)this.findChildByType(type);
        if (containerNode == null) {
            return null;
        }
        return containerNode.findChildByClass(JetExpression.class);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/jet/lang/psi/JetExpressionImpl", "replace"));
        }
        PsiElement parent = this.getParent();
        if (parent instanceof JetExpression && newElement instanceof JetExpression && JetPsiUtil.areParenthesesNecessary((JetExpression)newElement, this, (JetExpression)parent)) {
            return super.replace(JetPsiFactory.createExpression(this.getProject(), "(" + newElement.getText() + ")"));
        }
        return super.replace(newElement);
    }
}

