/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.OverridingUtil;

public class OverloadUtil {
    public static OverloadCompatibilityInfo isOverloadable(CallableDescriptor a, CallableDescriptor b) {
        int bbc;
        int abc = OverloadUtil.braceCount(a);
        if (abc != (bbc = OverloadUtil.braceCount(b))) {
            return OverloadCompatibilityInfo.success();
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.isOverridableByImpl(a, b, false);
        switch (overrideCompatibilityInfo.getResult()) {
            case OVERRIDABLE: 
            case CONFLICT: {
                return OverloadCompatibilityInfo.someError();
            }
            case INCOMPATIBLE: {
                return OverloadCompatibilityInfo.success();
            }
        }
        throw new IllegalStateException();
    }

    private static int braceCount(CallableDescriptor a) {
        if (a instanceof PropertyDescriptor) {
            return 0;
        }
        if (a instanceof SimpleFunctionDescriptor) {
            return 1;
        }
        if (a instanceof ConstructorDescriptor) {
            return 1;
        }
        throw new IllegalStateException();
    }

    public static class OverloadCompatibilityInfo {
        private static final OverloadCompatibilityInfo SUCCESS = new OverloadCompatibilityInfo(true, "SUCCESS");
        private final boolean isSuccess;
        private final String message;

        public static OverloadCompatibilityInfo success() {
            return SUCCESS;
        }

        public static OverloadCompatibilityInfo someError() {
            return new OverloadCompatibilityInfo(false, "XXX");
        }

        public OverloadCompatibilityInfo(boolean success, String message) {
            this.isSuccess = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

