/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;

public class JsConstructExpressionVisitor
extends RecursiveJsVisitor {
    private boolean containsInvocation;

    public static boolean exec(JsExpression expression) {
        if (JsPrecedenceVisitor.exec(expression) < 15) {
            return true;
        }
        JsConstructExpressionVisitor visitor = new JsConstructExpressionVisitor();
        visitor.accept(expression);
        return visitor.containsInvocation;
    }

    private JsConstructExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(JsArrayAccess x) {
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(JsArrayLiteral x) {
    }

    @Override
    public void visitFunction(JsFunction x) {
    }

    @Override
    public void visitInvocation(JsInvocation invocation) {
        this.containsInvocation = true;
    }

    @Override
    public void visitNameRef(JsNameRef nameRef) {
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(JsNew x) {
    }

    @Override
    public void visitObjectLiteral(JsObjectLiteral x) {
    }

    @Override
    public <T extends JsNode> void accept(T node) {
        JsExpression expression;
        int precedence;
        if (node instanceof JsExpression && (precedence = JsPrecedenceVisitor.exec(expression = (JsExpression)node)) < 15) {
            return;
        }
        super.accept(node);
    }
}

