/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList;
            if (element instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)element).getArgumentList()) != null) {
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(argumentList);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
                }
                return list2;
            }
            List<PsiClassType> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list3;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result = methodRef.advancedResolve(false);
            List<PsiClassType> list4 = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list4;
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).resolveMethodGenerics();
            List<PsiClassType> list5 = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list5;
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                List<PsiClassType> list6 = Collections.emptyList();
                if (list6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
                }
                return list6;
            }
            List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(expr);
            ArrayList<PsiClassType> classTypes = new ArrayList<PsiClassType>(ContainerUtil.mapNotNull(types, new NullableFunction<PsiType, PsiClassType>(){

                @Override
                public PsiClassType fun(PsiType type) {
                    return type instanceof PsiClassType ? (PsiClassType)type : null;
                }
            }));
            ExceptionUtil.addExceptions(classTypes, ExceptionUtil.getThrownExceptions(expr));
            ArrayList<PsiClassType> arrayList = classTypes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return arrayList;
        }
        if (element instanceof PsiTryStatement) {
            List<PsiClassType> list7 = ExceptionUtil.getTryExceptions((PsiTryStatement)element);
            if (list7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list7;
        }
        if (element instanceof PsiResourceVariable) {
            PsiResourceVariable variable = (PsiResourceVariable)element;
            ArrayList<PsiClassType> types = ContainerUtil.newArrayList();
            ExceptionUtil.addExceptions(types, ExceptionUtil.getCloserExceptions(variable));
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ExceptionUtil.addExceptions(types, ExceptionUtil.getThrownExceptions(initializer));
            }
            ArrayList<PsiClassType> arrayList = types;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return arrayList;
        }
        List<PsiClassType> list8 = ExceptionUtil.getThrownExceptions(element.getChildren());
        if (list8 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return list8;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceVariable variable : resourceList.getResourceVariables()) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(variable, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiElement psiElement : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiElement));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(finallyBlock);
                if ((completionReasons & 1) == 0) {
                    array = ContainerUtil.newArrayList(list2);
                } else {
                    ExceptionUtil.addExceptions(array, list2);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(@NotNull PsiElement element, @NotNull JavaResolveResult resolveResult) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method != null) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor()));
        }
        ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(element.getChildren()));
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        for (PsiType type : referenceTypes = method.getThrowsList().getReferencedTypes()) {
            if (!((type = substitutor.substitute(type)) instanceof PsiClassType)) continue;
            result.add((PsiClassType)type);
        }
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "addException"));
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        List<PsiClassType> unhandled;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement, includeSelfCalls);
        } else if (element instanceof PsiMethodReferenceExpression) {
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, topElement);
        } else if (element instanceof PsiThrowStatement) {
            PsiThrowStatement statement = (PsiThrowStatement)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
        } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
            PsiMethod constructor = (PsiMethod)element.getParent();
            PsiClass aClass = constructor.getContainingClass();
            PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
            PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
            HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
            for (PsiMethod superConstructor : superConstructors) {
                PsiClassType[] exceptionTypes;
                if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                    unhandled2.add(exceptionType);
                }
                break;
            }
            if (aClass != null) {
                PsiClassInitializer[] initializers = aClass.getInitializers();
                THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                for (PsiClassInitializer initializer : initializers) {
                    if (initializer.hasModifierProperty("static")) continue;
                    thrownByInitializer.clear();
                    ExceptionUtil.collectUnhandledExceptions(initializer.getBody(), initializer, thrownByInitializer, includeSelfCalls);
                    for (PsiClassType thrown : thrownByInitializer) {
                        if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                        unhandled2.add(thrown);
                    }
                }
            }
            unhandledExceptions = unhandled2;
        }
        if (element instanceof PsiResourceVariable && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, topElement)).isEmpty()) {
            if (unhandledExceptions == null) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            } else {
                unhandledExceptions.addAll(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            foundExceptions = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, includeSelfCalls);
        }
        return foundExceptions;
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod) {
            List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, (PsiElement)methodReferenceExpression, topElement, resolveResult.getSubstitutor());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list2;
        }
        List<PsiClassType> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list3;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        if (constructorBody == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "firstStatementIsConstructorCall"));
        }
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitCallExpression(@NotNull PsiCallExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil$2", "visitCallExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
                if (statement == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil$2", "visitThrowStatement"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement, null));
                this.visitElement(statement);
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil$2", "visitMethodReferenceExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitResourceVariable(@NotNull PsiResourceVariable resourceVariable) {
                if (resourceVariable == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil$2", "visitResourceVariable"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resourceVariable, null));
                this.visitElement(resourceVariable);
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement element) {
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(expression, null);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list2;
        }
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)element;
            List<PsiClassType> list3 = ExceptionUtil.getUnhandledExceptions(throwStatement, null);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list3;
        }
        if (element instanceof PsiResourceVariable) {
            List<PsiClassType> list4 = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, null);
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list4;
        }
        List<PsiClassType> list5 = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list5;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        block12: {
            block13: {
                if (methodCall == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                }
                result = methodCall.resolveMethodGenerics();
                method = (PsiMethod)result.getElement();
                containingMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
                if (!includeSelfCalls && method == containingMethod) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v0;
                }
                substitutor = result.getSubstitutor();
                if (method == null || ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression) || (thrownExceptions = method.getThrowsList().getReferencedTypes()).length <= 0) break block12;
                containingFile = (containingMethod == null ? methodCall : containingMethod).getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), new Function<CandidateInfo, Pair<PsiMethod, PsiSubstitutor>>(){

                        @Override
                        public Pair<PsiMethod, PsiSubstitutor> fun(CandidateInfo info) {
                            PsiElement element = info.getElement();
                            return element instanceof PsiMethod && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element) ? Pair.create((PsiMethod)element, info.getSubstitutor()) : null;
                        }
                    });
                    if (candidates.size() <= 1) break block12;
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions);
lbl20:
                    // 2 sources

                    for (Pair<PsiMethod, PsiSubstitutor> pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v1 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block13;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl38
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v2;
                }
            }
            if (v1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v1;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions));
                ** GOTO lbl20
lbl38:
                // 1 sources

                v3 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()]));
            }
            if (v3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v3;
        }
        v4 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
        }
        return v4;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType)) continue;
                replacement.add(psiClassType);
                iterator2.remove();
                found = true;
                break;
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiType psiType = substitutor.substitute(thrownException);
            if (!(psiType instanceof PsiClassType)) continue;
            ex.add((PsiClassType)psiType);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceVariable resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        PsiMethod method = PsiUtil.getResourceCloserMethod(resource);
        List<PsiClassType> list2 = method != null ? ExceptionUtil.getExceptionsByMethod(method, PsiSubstitutor.EMPTY) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceVariable resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        PsiMethod method = PsiUtil.getResourceCloserMethod(resource);
        List<PsiClassType> list2 = method != null ? ExceptionUtil.getUnhandledExceptions(method, (PsiElement)resource, topElement, PsiSubstitutor.EMPTY) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type).getDisjunctions() : Collections.singletonList(type);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled(throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression) {
        PsiType type;
        PsiElement target;
        if (expression instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list2 = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list2;
        }
        if (expression != null && (type = expression.getType()) != null) {
            List<PsiType> list3 = Arrays.asList(type);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list3;
        }
        List<PsiType> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
        }
        return list4;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@Nullable PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        if (method == null || ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list2;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list3 = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor, referencedTypes);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list3;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type = GenericsUtil.eliminateWildcards(substitutor.substitute(referencedType), false);
                if (!(type instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type;
                PsiClass exceptionClass = ((PsiClassType)type).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result.add((PsiClassType)type);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isArrayClone"));
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedException"));
        }
        return InheritanceUtil.isInheritor(type, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedExceptionOrSuperclass"));
        }
        return ExceptionUtil.isGeneralExceptionType(type) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isGeneralExceptionType"));
        }
        String canonicalText = type.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "isHandled"));
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiType interfaceType = ((PsiLambdaExpression)parent).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiType interfaceType = ((PsiMethodReferenceExpression)element).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            PsiClass aClass;
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element && (aClass = ((PsiField)parent).getContainingClass()) != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isDeclaredBySAMMethod"));
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "areAllConstructorsThrow"));
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "blockCompletesAbruptly"));
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        if (referencedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }
}

