/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.containers.HashMap;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    private final LinkedHashMap<String, String> myUserProperties = new LinkedHashMap();
    private final Map<String, String> myLoadedUserProperties = new HashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private static final Registry ourInstance;

    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") String key) {
        Registry registry = Registry.getInstance();
        if (registry.myValues.containsKey(key)) {
            return registry.myValues.get(key);
        }
        RegistryValue value = new RegistryValue(registry, key);
        registry.myValues.put(key, value);
        return value;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") String key) {
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") String key, boolean defaultValue) {
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") String key, int defaultValue) {
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("misc.registry");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static Registry getInstance() {
        return ourInstance;
    }

    Map<String, String> getUserProperties() {
        return this.myUserProperties;
    }

    static {
        ourInstance = new Registry();
    }
}

