/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    private final PsiAnnotation[] myAnnotations;

    protected PsiType(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "<init>"));
        }
        this.myAnnotations = annotations;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return psiArrayType;
    }

    @NotNull
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        PsiArrayType psiArrayType = new PsiArrayType(this, annotations);
        if (psiArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return psiArrayType;
    }

    @NonNls
    public abstract String getPresentableText();

    @NonNls
    public abstract String getCanonicalText();

    @NonNls
    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "isAssignableFrom"));
        }
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "isConvertibleFrom"));
        }
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NonNls String var1);

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.Object", resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        return psiClassType;
    }

    public static PsiClassType getJavaLangClass(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        return factory.createTypeByFQClassName("java.lang.Class", resolveScope);
    }

    public static PsiClassType getJavaLangThrowable(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        return factory.createTypeByFQClassName("java.lang.Throwable", resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangString(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.String", resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangString"));
        }
        return psiClassType;
    }

    public static PsiClassType getJavaLangError(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        return factory.createTypeByFQClassName("java.lang.Error", resolveScope);
    }

    public static PsiClassType getJavaLangRuntimeException(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        return factory.createTypeByFQClassName("java.lang.RuntimeException", resolveScope);
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getDeepComponentType"));
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (this.myAnnotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotations"));
        }
        return this.myAnnotations;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "findAnnotation"));
        }
        for (PsiAnnotation annotation : this.myAnnotations) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiType", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    protected String getAnnotationsTextPrefix(boolean qualified, boolean leadingSpace, boolean trailingSpace) {
        PsiAnnotation[] annotations = this.getAnnotations();
        if (annotations.length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotationsTextPrefix"));
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (leadingSpace) {
            sb.append(' ');
        }
        for (int i = 0; i < annotations.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            PsiAnnotation annotation = annotations[i];
            if (qualified) {
                sb.append('@').append(annotation.getQualifiedName()).append(annotation.getParameterList().getText());
                continue;
            }
            sb.append(annotation.getText());
        }
        if (trailingSpace) {
            sb.append(' ');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotationsTextPrefix"));
        }
        return string;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }
}

