/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");

    @NotNull
    public abstract <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement var1, @NotNull Class<Psi> var2);

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        ArrayList<Psi> augments = new ArrayList<Psi>();
        for (PsiAugmentProvider provider : Extensions.getExtensions(EP_NAME)) {
            List<Psi> list2 = provider.getAugments(element, type);
            augments.addAll(list2);
        }
        ArrayList<Psi> arrayList = augments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return arrayList;
    }
}

