/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class MinifiedFilesUtil {
    private MinifiedFilesUtil() {
    }

    public static boolean isMinified(Lexer lexer, ParserDefinition parserDefinition, TokenSet noWSRequireAfterTokenSet) {
        int offsetIgnoringComments = 0;
        int offsetIgnoringCommentsAndStrings = 0;
        int lineLength = 0;
        int unneededWhitespaceCount = 0;
        IElementType lastTokenType = null;
        TokenSet whitespaceTokens = parserDefinition.getWhitespaceTokens();
        TokenSet stringLiteralElements = parserDefinition.getStringLiteralElements();
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            if (commentTokens.contains(tokenType)) {
                lastTokenType = tokenType;
            } else {
                int tokenLength = lexer.getTokenEnd() - lexer.getTokenStart();
                offsetIgnoringComments += tokenLength;
                if (stringLiteralElements.contains(tokenType)) {
                    lineLength += tokenLength;
                    lastTokenType = tokenType;
                } else {
                    offsetIgnoringCommentsAndStrings += tokenLength;
                    if (whitespaceTokens.contains(tokenType)) {
                        if (!commentTokens.contains(lastTokenType) && tokenLength > 1) {
                            return false;
                        }
                        if (lexer.getTokenText().contains("\n")) {
                            if (lineLength > 100) break;
                            lineLength = 0;
                        }
                        if (" ".equals(lexer.getTokenText()) && noWSRequireAfterTokenSet.contains(lastTokenType)) {
                            ++unneededWhitespaceCount;
                        }
                    } else {
                        lineLength += tokenLength;
                    }
                    if (offsetIgnoringComments >= 2048) break;
                    lastTokenType = tokenType;
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return offsetIgnoringComments >= 150 && ((double)unneededWhitespaceCount + 0.0) / (double)offsetIgnoringCommentsAndStrings < 0.01;
    }

    public static boolean isMinified(Lexer lexer, ParserDefinition parserDefinition) {
        return MinifiedFilesUtil.isMinified(lexer, parserDefinition, TokenSet.EMPTY);
    }
}

