/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder);
        }
    };

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(String exprText, PsiManager manager, ClsElementImpl parent) {
        PsiExpression expr;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        PsiJavaFile dummyJavaFile = ((PsiJavaParserFacadeImpl)parserFacade).getDummyJavaFile();
        try {
            expr = parserFacade.createExpressionFromText(exprText, dummyJavaFile);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
        return ClsParsingUtil.psiToClsExpression(expr, parent);
    }

    @NotNull
    public static PsiAnnotationMemberValue createMemberValueFromText(String text, PsiManager manager, ClsElementImpl parent) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiJavaFile context = ((PsiJavaParserFacadeImpl)((Object)factory)).getDummyJavaFile();
        LanguageLevel level = PsiUtil.getLanguageLevel(parent);
        DummyHolder holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createMemberValueFromText"));
            }
            return null;
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = ClsParsingUtil.getMemberValue(element, parent);
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "createMemberValueFromText"));
        }
        return psiAnnotationMemberValue;
    }

    @NotNull
    public static PsiAnnotationMemberValue getMemberValue(PsiElement element, ClsElementImpl parent) {
        if (element instanceof PsiExpression) {
            PsiExpression psiExpression = ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
            }
            return psiExpression;
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            for (int i = 0; i < initializers.length; ++i) {
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
            }
            ClsArrayInitializerMemberValueImpl clsArrayInitializerMemberValueImpl = arrayValue;
            if (clsArrayInitializerMemberValueImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
            }
            return clsArrayInitializerMemberValueImpl;
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            ClsAnnotationValueImpl clsAnnotationValueImpl = new ClsAnnotationValueImpl(parent){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                @Override
                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)((Object)this.getParent());
                }
            };
            if (clsAnnotationValueImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
            }
            return clsAnnotationValueImpl;
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "getMemberValue"));
        }
        return null;
    }

    @NotNull
    private static PsiExpression psiToClsExpression(PsiExpression expr, @Nullable ClsElementImpl parent) {
        String exprText;
        if (expr instanceof PsiLiteralExpression) {
            ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), ((PsiLiteralExpression)expr).getValue());
            if (clsLiteralExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
            }
            return clsLiteralExpressionImpl;
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpr = (PsiPrefixExpression)expr;
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, prefixExpr.getOperationTokenType(), prefixExpr.getOperationSign().getText());
            ClsLiteralExpressionImpl literal = (ClsLiteralExpressionImpl)ClsParsingUtil.psiToClsExpression(prefixExpr.getOperand(), null);
            ClsPrefixExpressionImpl clsPrefixExpressionImpl = new ClsPrefixExpressionImpl(parent, operation, literal);
            if (clsPrefixExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
            }
            return clsPrefixExpressionImpl;
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith(exprText = expr.getText(), ".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            ClsClassObjectAccessExpressionImpl clsClassObjectAccessExpressionImpl = new ClsClassObjectAccessExpressionImpl(parent, classText);
            if (clsClassObjectAccessExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
            }
            return clsClassObjectAccessExpressionImpl;
        }
        if (expr instanceof PsiReferenceExpression) {
            ClsReferenceExpressionImpl clsReferenceExpressionImpl = new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)expr);
            if (clsReferenceExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
            }
            return clsReferenceExpressionImpl;
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpr = (PsiBinaryExpression)expr;
            PsiExpression lOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getLOperand(), null);
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, binaryExpr.getOperationTokenType(), binaryExpr.getOperationSign().getText());
            PsiExpression rOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getROperand(), null);
            if (lOperand instanceof ClsLiteralExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsLiteralExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                if (clsBinaryExpressionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
                }
                return clsBinaryExpressionImpl;
            }
            if (lOperand instanceof ClsPrefixExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsPrefixExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                if (clsBinaryExpressionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
                }
                return clsBinaryExpressionImpl;
            }
        } else {
            PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
            Object value = evaluator.computeConstantExpression(expr);
            if (value != null) {
                ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), value);
                if (clsLiteralExpressionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
                }
                return clsLiteralExpressionImpl;
            }
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsParsingUtil", "psiToClsExpression"));
        }
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsParsingUtil", "isJavaIdentifier"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsParsingUtil", "isJavaIdentifier"));
        }
        return StringUtil.isJavaIdentifier(identifier) && !JavaLexer.isKeyword(identifier, level);
    }
}

