/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.LiftParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    private final Map<PsiTypeParameter, InferenceVariable> myInferenceVariables = new LinkedHashMap<PsiTypeParameter, InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);

    public InferenceSession(PsiSubstitutor siteSubstitutor) {
        this.mySiteSubstitutor = siteSubstitutor;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null) continue;
            this.myConstraints.add(new TypeCompatibilityConstraint(leftTypes[i], rightType));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent) {
        Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || pair != null && !InferenceSession.isPertinentToApplicability(args[i], (PsiMethod)pair.first)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                this.myConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
            }
        }
    }

    private static Pair<PsiMethod, PsiCallExpression> getPair(PsiElement parent) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        if (parent instanceof PsiCallExpression && (pair = MethodCandidateInfo.getCurrentMethod(((PsiCallExpression)parent).getArgumentList())) != null) {
            return Pair.create(pair.first, (PsiCallExpression)parent);
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        if (expr instanceof PsiLambdaExpression) {
            if (!((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                if (InferenceSession.isPertinentToApplicability(expression, method)) continue;
                return false;
            }
            if (method != null && method.getTypeParameters().length > 0) {
                PsiElement gParent;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
                if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
                    PsiType paramType;
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(paramType);
                    if (psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method) {
                        return false;
                    }
                }
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (!PsiPolyExpressionUtil.isPolyExpression(expression)) continue;
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, PsiExpression[] args, int i, PsiSubstitutor substitutor) {
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType && (args.length != parameters.length || PsiPolyExpressionUtil.isPolyExpression(args[i]) || args[i] != null && !(args[i].getType() instanceof PsiArrayType))) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, DefaultParameterTypeInferencePolicy.INSTANCE);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, ParameterTypeInferencePolicy policy) {
        boolean doesNotContainFalseBound = this.repeatInferencePhases();
        this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, false);
        Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
        if (pair != null) {
            this.initReturnTypeConstraint((PsiMethod)pair.first, (PsiCallExpression)parent);
            for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
                inferenceVariable.ignoreInstantiation();
            }
            doesNotContainFalseBound = this.repeatInferencePhases();
            this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, false);
        }
        if (parameters != null && args != null) {
            HashSet<ConstraintFormula> additionalConstraints = new HashSet<ConstraintFormula>();
            if (parameters.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                    if (pair == null || !InferenceSession.isPertinentToApplicability(args[i], (PsiMethod)pair.first)) {
                        additionalConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
                    }
                    additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(args[i], parameterType));
                }
            }
            if (!additionalConstraints.isEmpty()) {
                for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
                    inferenceVariable.ignoreInstantiation();
                }
                doesNotContainFalseBound = this.proceedWithAdditionalConstraints(additionalConstraints);
            }
        }
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            inferenceVariable.ignoreInstantiation();
        }
        this.mySiteSubstitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, !policy.allowPostponeInference());
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            PsiTypeParameter typeParameter = inferenceVariable.getParameter();
            PsiType instantiation = inferenceVariable.getInstantiation();
            if (instantiation != PsiType.NULL) continue;
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
        }
        PsiSubstitutor psiSubstitutor = this.mySiteSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private void initBounds(PsiTypeParameter ... typeParameters) {
        for (PsiTypeParameter parameter : typeParameters) {
            PsiClassType[] extendsListTypes;
            if (this.myInferenceVariables.containsKey(parameter)) continue;
            InferenceVariable variable = new InferenceVariable(parameter);
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.mySiteSubstitutor.substitute(classType))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (!added) {
                variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
            }
            this.myInferenceVariables.put(parameter, variable);
        }
    }

    public void addCapturedVariable(PsiTypeParameter param) {
        if (this.myInferenceVariables.containsKey(param)) {
            return;
        }
        this.initBounds(param);
    }

    private void initReturnTypeConstraint(PsiMethod method, final PsiCallExpression context) {
        PsiType returnType;
        if ((PsiPolyExpressionUtil.isMethodCallPolyExpression(context, method) || context instanceof PsiNewExpression && PsiDiamondType.ourDiamondGuard.currentStack().contains(context)) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
            PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
            if (targetType == null) {
                targetType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(context, true, new Computable<PsiType>(){

                    @Override
                    public PsiType compute() {
                        return InferenceSession.this.getTargetType(context);
                    }
                });
            }
            if (targetType != null) {
                this.myConstraints.add(new TypeCompatibilityConstraint(GenericsUtil.eliminateWildcards(targetType, false), PsiImplUtil.normalizeWildcardTypeByPosition(returnType, context)));
            }
        }
    }

    private PsiType getTargetType(final PsiExpression context) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                Pair<PsiMethod, PsiSubstitutor> pair = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (pair == null) {
                    JavaResolveResult[] results;
                    MethodCandidatesProcessor processor = new MethodCandidatesProcessor(gParent, context.getContainingFile()){

                        @Override
                        protected PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
                            if (argumentList != null) {
                                PsiExpression[] expressions = argumentList.getExpressions();
                                int idx = LambdaUtil.getLambdaIdx(argumentList, context);
                                PsiType[] types = new PsiType[expressions.length];
                                for (int i = 0; i < expressions.length; ++i) {
                                    types[i] = i != idx ? expressions[i].getType() : PsiType.NULL;
                                }
                                return types;
                            }
                            return null;
                        }
                    };
                    try {
                        PsiScopesUtil.setupAndRunProcessor(processor, (PsiCallExpression)gParent, false);
                    }
                    catch (MethodProcessorSetupFailedException e) {
                        return null;
                    }
                    for (JavaResolveResult result : results = processor.getResult()) {
                        PsiType type = this.getTypeByMethod(context, argumentList, null, result, result.getElement());
                        if (type == null) continue;
                        return type;
                    }
                    return null;
                }
                return this.getTypeByMethod(context, argumentList, pair, null, (PsiElement)pair.first);
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent);
                if (targetType == null) {
                    targetType = this.getTargetType((PsiExpression)parent);
                }
                return targetType;
            }
            if (parent instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceReturnType(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            }
        }
        return null;
    }

    private PsiType getTypeByMethod(PsiExpression context, PsiExpressionList argumentList, Pair<PsiMethod, PsiSubstitutor> pair, JavaResolveResult result, PsiElement parentMethod) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            if (pair != null) {
                return InferenceSession.getParameterType(parameters, args, i, (PsiSubstitutor)pair.second);
            }
            args[i] = null;
            PsiTypeParameter[] typeParameters = ((PsiMethod)parentMethod).getTypeParameters();
            this.initBounds(typeParameters);
            PsiSubstitutor substitutor = ((MethodCandidateInfo)result).inferSubstitutorFromArgs(LiftParameterTypeInferencePolicy.INSTANCE, args);
            return InferenceSession.getParameterType(parameters, args, i, substitutor);
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof PsiTypeParameter) {
            return this.myInferenceVariables.get(psiClass);
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    private boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            this.myIncorporationPhase.incorporate();
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor, boolean acceptObject) {
        List<List<InferenceVariable>> independentVars = InferenceVariablesOrder.resolveOrder(inferenceVariables, this);
        for (List<InferenceVariable> variables : independentVars) {
            for (InferenceVariable inferenceVariable : variables) {
                if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                try {
                    List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                    List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                    List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                    if (upperBounds.contains(null)) {
                        inferenceVariable.setInstantiation(null);
                        continue;
                    }
                    PsiType bound = null;
                    if (eqBounds.size() > 1) {
                        Iterator<PsiType> iterator2 = eqBounds.iterator();
                        while (iterator2.hasNext()) {
                            PsiType eqBound = this.acceptBoundsWithRecursiveDependencies(inferenceVariable, iterator2.next(), substitutor);
                            if (PsiUtil.resolveClassInType(eqBound) == typeParameter || !(bound instanceof PsiCapturedWildcardType) && Comparing.equal(bound, eqBound)) {
                                iterator2.remove();
                                continue;
                            }
                            if (bound != null) continue;
                            bound = eqBound;
                        }
                        if (eqBounds.size() > 1) continue;
                    }
                    PsiType psiType = bound = eqBounds.isEmpty() ? null : this.acceptBoundsWithRecursiveDependencies(inferenceVariable, eqBounds.get(0), substitutor);
                    if (bound != null) {
                        inferenceVariable.setInstantiation(bound);
                        continue;
                    }
                    PsiType lub = null;
                    for (PsiType lowerBound : lowerBounds) {
                        if (!this.isProperType(lowerBound = this.acceptBoundsWithRecursiveDependencies(inferenceVariable, lowerBound, substitutor))) continue;
                        if (lub == null) {
                            lub = lowerBound;
                            continue;
                        }
                        lub = GenericsUtil.getLeastUpperBound(lub, lowerBound, this.myManager);
                    }
                    if (lub != null) {
                        inferenceVariable.setInstantiation(lub instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)lub).getWildcard() : lub);
                        continue;
                    }
                    PsiType glb = null;
                    if (InferenceSession.isThrowable(upperBounds)) {
                        glb = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                    } else {
                        for (PsiType upperBound : upperBounds) {
                            if (!this.isProperType(upperBound = this.acceptBoundsWithRecursiveDependencies(inferenceVariable, upperBound, substitutor))) continue;
                            if (glb == null) {
                                glb = upperBound;
                                continue;
                            }
                            glb = GenericsUtil.getGreatestLowerBound(glb, upperBound);
                        }
                    }
                    if (glb == null || !acceptObject && glb.equalsToText("java.lang.Object")) continue;
                    inferenceVariable.setInstantiation(glb);
                }
                finally {
                    PsiType instantiation = inferenceVariable.getInstantiation();
                    if (instantiation == PsiType.NULL) continue;
                    substitutor = substitutor.put(typeParameter, instantiation);
                }
            }
        }
        return substitutor;
    }

    private static boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object")) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType acceptBoundsWithRecursiveDependencies(InferenceVariable inferenceVariable, PsiType bound, PsiSubstitutor substitutor) {
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        boolean collectDependencies = this.collectDependencies(bound, dependencies);
        if (collectDependencies) {
            PsiSubstitutor subst = !dependencies.contains(inferenceVariable) ? substitutor.put(inferenceVariable.getParameter(), null) : substitutor;
            return subst.substitute(bound);
        }
        return bound;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables.values();
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (!this.myConstraints.contains(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    public Collection<PsiTypeParameter> getTypeParams() {
        return this.myInferenceVariables.keySet();
    }

    public void addVariable(PsiTypeParameter typeParameter, PsiType parameter) {
        InferenceVariable variable = new InferenceVariable(typeParameter);
        if (parameter instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)parameter).getBound();
            if (bound != null) {
                variable.addBound(bound, ((PsiWildcardType)parameter).isExtends() ? InferenceBound.UPPER : InferenceBound.LOWER);
            } else {
                variable.addBound(PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope()), InferenceBound.UPPER);
            }
        } else {
            variable.addBound(parameter, InferenceBound.EQ);
        }
        this.myInferenceVariables.put(typeParameter, variable);
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        while (!additionalConstraints.isEmpty()) {
            HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
            for (ConstraintFormula constraint : additionalConstraints) {
                Set<InferenceVariable> inputVariables;
                Set<InferenceVariable> outputVars;
                if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
                outputVariables.addAll(outputVars);
            }
            Set<Object> subset = new HashSet<ConstraintFormula>();
            HashSet<InferenceVariable> varsToResolve = new HashSet<InferenceVariable>();
            for (ConstraintFormula constraint : additionalConstraints) {
                if (constraint instanceof InputOutputConstraintFormula) {
                    Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                    if (inputVariables != null) {
                        boolean dependsOnOutput = false;
                        for (InferenceVariable inputVariable : inputVariables) {
                            Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                            dependencies.add(inputVariable);
                            dependencies.retainAll(outputVariables);
                            if (dependencies.isEmpty()) continue;
                            dependsOnOutput = true;
                            break;
                        }
                        if (dependsOnOutput) continue;
                        subset.add(constraint);
                        varsToResolve.addAll(inputVariables);
                        continue;
                    }
                    subset.add(constraint);
                    Set<InferenceVariable> outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(null, this);
                    if (outputVars == null) continue;
                    varsToResolve.addAll(outputVars);
                    continue;
                }
                subset.add(constraint);
            }
            if (subset.isEmpty()) {
                subset = Collections.singleton(additionalConstraints.iterator().next());
            }
            additionalConstraints.removeAll(subset);
            this.myConstraints.addAll(subset);
            if (!this.repeatInferencePhases()) {
                return false;
            }
            PsiSubstitutor substitutor = this.resolveBounds(varsToResolve, this.mySiteSubstitutor, false);
            for (ConstraintFormula additionalConstraint : additionalConstraints) {
                additionalConstraint.apply(substitutor);
            }
        }
        return true;
    }
}

