/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.List;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiType returnType;
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (LambdaHighlightingUtil.checkInterfaceFunctional(this.myT) != null) {
            return false;
        }
        if (this.myExpression.hasFormalParameterTypes()) {
            // empty if block
        }
        if ((interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(FunctionalInterfaceParameterizationUtil.getFunctionalType(this.myT, this.myExpression, false)))) == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
        if (lambdaParameters.length != parameters.length) {
            return false;
        }
        if (this.myExpression.hasFormalParameterTypes()) {
            for (int i = 0; i < lambdaParameters.length; ++i) {
                constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), substitutor.substitute(parameters[i].getType())));
            }
        } else {
            for (PsiParameter parameter : parameters) {
                if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                return false;
            }
        }
        if ((returnType = interfaceMethod.getReturnType()) != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            if (returnType.equals(PsiType.VOID)) {
                if (!returnExpressions.isEmpty() && !(this.myExpression.getBody() instanceof PsiExpression)) {
                    return false;
                }
            } else {
                if (returnExpressions.isEmpty() && !this.myExpression.isValueCompatible()) {
                    return false;
                }
                for (PsiExpression returnExpression : returnExpressions) {
                    constraints.add(new ExpressionCompatibilityConstraint(returnExpression, GenericsUtil.eliminateWildcards(substitutor.substitute(returnType))));
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor) {
        this.myT = substitutor.substitute(this.myT);
    }
}

