/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.CompositeElement");
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myModificationsCount;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;

    public CompositeElement(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "<init>"));
        }
        super(type);
        this.firstChild = null;
        this.lastChild = null;
        this.myModificationsCount = 0;
        this.myCachedLength = -1;
        this.myHC = -1;
        this.myWrapper = null;
    }

    public int getModificationCount() {
        return this.myModificationsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        Object object2 = PsiLock.LOCK;
        synchronized (object2) {
            clone.firstChild = null;
            clone.lastChild = null;
            clone.myModificationsCount = 0;
            clone.myWrapper = null;
            for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
                clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
            }
            clone.clearCaches();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtreeChanged() {
        Object object2 = PsiLock.LOCK;
        synchronized (object2) {
            for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
                compositeElement.clearCaches();
                if (compositeElement instanceof PsiElement) continue;
                PsiElement psi = compositeElement.myWrapper;
                if (psi instanceof ASTDelegatePsiElement) {
                    ((ASTDelegatePsiElement)psi).subtreeChanged();
                    continue;
                }
                if (!(psi instanceof PsiFile)) continue;
                ((PsiFile)psi).subtreeChanged();
            }
        }
    }

    @Override
    public void clearCaches() {
        this.assertThreading();
        this.myCachedLength = -1;
        ++this.myModificationsCount;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    public void assertThreading() {
        boolean ok;
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || this.isNonPhysicalOrInjected();
        if (!ok) {
            LOG.error("Threading assertion. " + this.getThreadingDiagnostics());
        }
    }

    private String getThreadingDiagnostics() {
        FileElement fileElement = TreeUtil.getFileElement(this);
        PsiFile psiFile = fileElement == null ? null : (PsiFile)fileElement.getPsi();
        return " Under write: " + ApplicationManager.getApplication().isWriteAccessAllowed() + "; Thread.holdsLock(PsiLock.LOCK): " + Thread.holdsLock(PsiLock.LOCK) + "; wrapper: " + this.myWrapper + "; wrapper.isPhysical(): " + (this.myWrapper != null && this.myWrapper.isPhysical()) + "; fileElement: " + fileElement + "; psiFile: " + psiFile + "; psiFile.getViewProvider(): " + (psiFile == null ? null : psiFile.getViewProvider()) + "; psiFile.isPhysical(): " + (psiFile != null && psiFile.isPhysical()) + "; nonPhysicalOrInjected: " + this.isNonPhysicalOrInjected();
    }

    private boolean isNonPhysicalOrInjected() {
        PsiElement wrapper;
        FileElement fileElement = TreeUtil.getFileElement(this);
        if (fileElement == null || fileElement instanceof DummyHolderElement) {
            return true;
        }
        if (fileElement.getTreeParent() != null) {
            return true;
        }
        PsiElement psiElement = wrapper = this instanceof PsiElement ? (PsiElement)((Object)this) : this.myWrapper;
        if (wrapper == null) {
            return true;
        }
        PsiFile psiFile = wrapper.getContainingFile();
        return psiFile == null || psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element = this;
        block0: while (true) {
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = child.getTreeNext();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    element = child;
                    continue block0;
                }
                offset -= textLength;
                child = child.getTreeNext();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(IElementType type) {
        ASTNode node = this.findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    public ASTNode findChildByType(IElementType type, ASTNode anchor) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        ASTNode child = anchor;
        while (child != null) {
            if (type == child.getElementType()) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "findChildByType"));
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "findChildByType"));
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        ASTNode child = anchor;
        while (child != null) {
            if (typesSet.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = StringFactory.createShared(this.textToCharArray());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getText"));
        }
        return string;
    }

    @Override
    public CharSequence getChars() {
        return this.getText();
    }

    @Override
    public int getNotCachedLength() {
        final int[] result = new int[]{0};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element)) {
                    result[0] = result[0] + element.getNotCachedLength();
                }
                super.visitNode(element);
            }
        });
        return result[0];
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        int endOffset;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int startStamp = this.myModificationsCount;
        int len = this.getTextLength();
        if (startStamp != this.myModificationsCount) {
            throw new AssertionError((Object)("Tree changed while calculating text. startStamp:" + startStamp + "; current:" + this.myModificationsCount + "; myHC:" + this.myHC + "; assertThreading:" + true + "; this: " + this + "\n" + this.getThreadingDiagnostics()));
        }
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer), startStamp);
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)), startStamp);
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "textToCharArray"));
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text, int startStamp) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n changed=" + (startStamp != this.myModificationsCount);
        msg = msg + ";\n nonPhysicalOrInjected=" + this.isNonPhysicalOrInjected();
        msg = msg + ";\n buffer=" + text;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file;
                msg = msg + ";\n psi.file.tl=" + file.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                PsiElement fileLeaf = file.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "textMatches"));
        }
        int curOffset = start;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if ((curOffset = child.textMatches(buffer, curOffset)) >= 0) continue;
            return curOffset;
        }
        return curOffset;
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result[count++] = child;
        }
        return result;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@Nullable TokenSet filter, ArrayFactory<T> constructor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
            }
            return result;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        return result;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@NotNull IElementType type, ArrayFactory<T> constructor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(type);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
            }
            return result;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (type != child.getElementType()) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        return result;
    }

    public int countChildren(@Nullable TokenSet filter) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    public int countChildren(IElementType type) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type != child.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "deleteChildInternal"));
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChildInternal"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChildInternal"));
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
        return this.myCachedLength;
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    private static TreeElement drillDown(TreeElement start) {
        TreeElement child;
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        return cur;
    }

    private void walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            if (cur.getCachedLength() < 0) {
                int length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : cur.getTreeParent();
        }
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, final @Nullable ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "addChild"));
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        final TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first);
                }
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "addLeaf"));
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "addChild"));
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "removeChild"));
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "removeRange"));
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChild"));
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange(CompositeElement.this, changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild);
                    } else {
                        TreeElement first = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        Object object2 = PsiLock.LOCK;
        synchronized (object2) {
            wrapper = this.myWrapper;
            if (wrapper != null) {
                return wrapper;
            }
            return this.createAndStorePsi();
        }
    }

    @Nullable
    public <T extends PsiElement> T getPsi(Class<T> clazz) {
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    private PsiElement createAndStorePsi() {
        PsiElement psi;
        this.myWrapper = psi = this.createPsiNoLock();
        return psi;
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "setPsi"));
        }
        this.myWrapper = psi;
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/CompositeElement", "rawAddChildren"));
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(TreeElement first) {
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            first.rawRemoveUpToWithoutNotifications(null, false);
            this.setFirstChildNode(first);
            while (true) {
                TreeElement treeNext = first.getTreeNext();
                first.setTreeParent(this);
                if (treeNext == null) break;
                first = treeNext;
            }
            this.setLastChildNode(first);
            first.setTreeParent(this);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAllChildrenPsiIfNecessary() {
        final ArrayList nodes = ContainerUtil.newArrayList();
        final ArrayList psiElements = ContainerUtil.newArrayList();
        RecursiveTreeElementWalkingVisitor visitor = new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitLeaf(LeafElement leaf) {
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                ProgressIndicatorProvider.checkCanceled();
                if (composite.myWrapper == null) {
                    nodes.add(composite);
                    psiElements.add(composite.createPsiNoLock());
                }
                super.visitComposite(composite);
            }
        };
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child.acceptTree(visitor);
        }
        Object object2 = PsiLock.LOCK;
        synchronized (object2) {
            for (int i = 0; i < psiElements.size(); ++i) {
                CompositeElement node = (CompositeElement)nodes.get(i);
                if (node.myWrapper != null) continue;
                node.myWrapper = (PsiElement)psiElements.get(i);
            }
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent, TreeElement first) {
        parent.rawAddChildren(first);
        for (TreeElement child = first; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            for (TreeElement child = first; child != last && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
            }
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first) {
        anchorBefore.rawInsertBeforeMe(first);
        for (TreeElement child = first; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newChild);
        sourceTreeChange.addElementaryChange(newChild, change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first, final TreeElement last) {
        final FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first, last);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first);
                }
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }
}

