/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl");
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "removeChild"));
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression = this.getMethodExpression();
        PsiReferenceParameterList result = expression.getParameterList();
        if (result != null) {
            PsiReferenceParameterList psiReferenceParameterList = result;
            if (psiReferenceParameterList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArgumentList"));
            }
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression, false));
        PsiReferenceParameterList psiReferenceParameterList = result;
        if (psiReferenceParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArgumentList"));
        }
        return psiReferenceParameterList;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getMethodExpression"));
        }
        return psiReferenceExpression;
    }

    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list2 = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list2 != null) {
            PsiExpressionList psiExpressionList = list2;
            if (psiExpressionList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getArgumentList"));
            }
            return psiExpressionList;
        }
        LOG.error("Invalid PSI. Children:" + DebugUtil.psiToString(this, false));
        PsiExpressionList psiExpressionList = list2;
        if (psiExpressionList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getArgumentList"));
        }
        return psiExpressionList;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodCallExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static PsiType captureReturnType(PsiMethodCallExpression call, PsiMethod method, PsiType ret, PsiSubstitutor substitutor) {
        PsiType substitutedReturnType = substitutor.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure(ret);
        }
        if (PsiUtil.isRawSubstitutor(method, substitutor)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure(ret);
            if (Comparing.equal(TypeConversionUtil.erasure(substitutedReturnType), returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        PsiType lowerBound = PsiType.NULL;
        if (substitutedReturnType instanceof PsiCapturedWildcardType) {
            lowerBound = ((PsiCapturedWildcardType)substitutedReturnType).getLowerBound();
        } else if (substitutedReturnType instanceof PsiWildcardType) {
            lowerBound = ((PsiWildcardType)substitutedReturnType).getSuperBound();
        }
        if (lowerBound != PsiType.NULL) {
            PsiClassType[] extendsListTypes;
            PsiType typeInChildClassTypeParams;
            PsiClass substituted;
            PsiClass childClass;
            PsiClass containingClass = method.getContainingClass();
            PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
            PsiClass psiClass = childClass = qualifierExpression != null ? PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType()) : null;
            if (containingClass != null && childClass != null && (substituted = PsiUtil.resolveClassInClassTypeOnly(typeInChildClassTypeParams = TypeConversionUtil.getSuperClassSubstitutor(containingClass, childClass, PsiSubstitutor.EMPTY).substitute(ret))) instanceof PsiTypeParameter && (extendsListTypes = substituted.getExtendsListTypes()).length == 1) {
                return extendsListTypes[0];
            }
        }
        return PsiImplUtil.normalizeWildcardTypeByPosition(substitutedReturnType, call);
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiType theOnly = null;
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            for (int i = 0; i < results.length; ++i) {
                PsiType type = TypeEvaluator.getResultType(call, methodExpression, results[i], languageLevel);
                if (type == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type;
                    continue;
                }
                if (theOnly.equals(type)) continue;
                return null;
            }
            return theOnly;
        }

        @Nullable
        private static PsiType getResultType(PsiMethodCallExpression call, PsiReferenceExpression methodExpression, JavaResolveResult result, @NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl$TypeEvaluator", "getResultType"));
            }
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            boolean is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(call, methodExpression, method, new Condition<IElementType>(){

                @Override
                public boolean value(IElementType type) {
                    return type != JavaElementType.CLASS;
                }
            }, languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call, method, ret, result.getSubstitutor());
            }
            return TypeConversionUtil.erasure(ret);
        }
    }
}

