/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ObjectStubTree<T extends Stub> {
    private static final Key<ObjectStubTree> STUB_TO_TREE_REFERENCE = Key.create("stub to tree reference");
    protected final ObjectStubBase myRoot;
    private String myDebugInfo;
    protected final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase root, boolean withBackReference) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/ObjectStubTree", "<init>"));
        }
        this.myPlainList = new ArrayList<T>();
        this.myRoot = root;
        ObjectStubTree.enumerateStubs(root, this.myPlainList);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, this);
        }
    }

    @NotNull
    public Stub getRoot() {
        ObjectStubBase objectStubBase = this.myRoot;
        if (objectStubBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "getRoot"));
        }
        return objectStubBase;
    }

    public List<T> getPlainList() {
        return this.myPlainList;
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, int[]>> indexStubTree() {
        StubIndexSink sink = new StubIndexSink();
        int plainListSize = this.myPlainList.size();
        for (int i = 0; i < plainListSize; ++i) {
            Stub stub = (Stub)this.myPlainList.get(i);
            sink.myStubIdx = i;
            StubSerializationUtil.getSerializer(stub).indexStub(stub, sink);
        }
        Map<StubIndexKey, Map<Object, int[]>> map = sink.getResult();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "indexStubTree"));
        }
        return map;
    }

    protected static void enumerateStubs(Stub root, List<Stub> result) {
        ((ObjectStubBase)root).id = result.size();
        result.add(root);
        for (Stub stub : root.getChildrenStubs()) {
            ObjectStubTree.enumerateStubs(stub, result);
        }
    }

    public void setDebugInfo(String info) {
        ObjectStubTree ref = this.myRoot.getUserData(STUB_TO_TREE_REFERENCE);
        if (ref != null) {
            assert (ref == this);
            info = info + "; with backReference";
        }
        this.myDebugInfo = info;
    }

    public String getDebugInfo() {
        return this.myDebugInfo;
    }

    private static class StubIndexSink
    implements IndexSink,
    TObjectObjectProcedure<Object, int[]>,
    TObjectProcedure<Map<Object, int[]>> {
        private final THashMap<StubIndexKey, Map<Object, int[]>> myResult = new THashMap();
        private int myStubIdx;
        private Map<Object, int[]> myProcessingMap;

        private StubIndexSink() {
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value) {
            int[] list2;
            if (indexKey == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink", "occurrence"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink", "occurrence"));
            }
            Map<Object, int[]> map = this.myResult.get(indexKey);
            if (map == null) {
                map = new THashMap<Object, int[]>();
                this.myResult.put(indexKey, map);
            }
            if ((list2 = map.get(value)) == null) {
                map.put(value, new int[]{this.myStubIdx});
            } else {
                int lastZero;
                for (lastZero = list2.length - 1; lastZero >= 0 && list2[lastZero] == 0; --lastZero) {
                }
                if (++lastZero == list2.length) {
                    int[] newlist = new int[Math.max(4, list2.length << 1)];
                    System.arraycopy(list2, 0, newlist, 0, list2.length);
                    lastZero = list2.length;
                    list2 = newlist;
                    map.put(value, newlist);
                }
                list2[lastZero] = this.myStubIdx;
            }
        }

        public Map<StubIndexKey, Map<Object, int[]>> getResult() {
            this.myResult.forEachValue(this);
            return this.myResult;
        }

        @Override
        public boolean execute(Map<Object, int[]> object2) {
            this.myProcessingMap = object2;
            ((THashMap)object2).forEachEntry(this);
            return true;
        }

        @Override
        public boolean execute(Object a, int[] b) {
            int firstZero;
            if (b.length == 1) {
                return true;
            }
            for (firstZero = 0; firstZero < b.length && b[firstZero] != 0; ++firstZero) {
            }
            if (firstZero != b.length) {
                int[] shorterList = new int[firstZero];
                System.arraycopy(b, 0, shorterList, 0, shorterList.length);
                this.myProcessingMap.put(a, shorterList);
            }
            return true;
        }
    }
}

