/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class FileIconKey {
    private final VirtualFile myFile;
    private final Project myProject;
    private final int myFlags;

    FileIconKey(@NotNull VirtualFile file, Project project, int flags) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/FileIconKey", "<init>"));
        }
        this.myFile = file;
        this.myProject = project;
        this.myFlags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        return !(this.myProject != null ? !this.myProject.equals(that.myProject) : that.myProject != null);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (this.myProject != null ? this.myProject.hashCode() : 0);
        result = 31 * result + this.myFlags;
        return result;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public int getFlags() {
        return this.myFlags;
    }
}

