/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IntArrayList
implements Cloneable {
    private int[] myData;
    private int mySize;

    public IntArrayList(int initialCapacity) {
        this.myData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(int elem) {
        for (int i = 0; i < this.mySize; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.myData = new int[this.mySize];
            System.arraycopy(this.myData, 0, v.myData, 0, this.mySize);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @NotNull
    public int[] toArray() {
        int[] result = new int[this.mySize];
        System.arraycopy(this.myData, 0, result, 0, this.mySize);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntArrayList", "toArray"));
        }
        return result;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public void add(int o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public int remove(int index) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

