/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.FloatIterator;
import jet.FloatProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class FloatProgression
implements Progression<Float> {
    private final float start;
    private final float end;
    private final float increment;

    public FloatProgression(float start, float end, float increment) {
        if (Float.isNaN(increment)) {
            throw new IllegalArgumentException("Increment must be not NaN");
        }
        if (increment == 0.0f || increment == -0.0f) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Float getStart() {
        return Float.valueOf(this.start);
    }

    @Override
    public Float getEnd() {
        return Float.valueOf(this.end);
    }

    @Override
    public Float getIncrement() {
        return Float.valueOf(this.increment);
    }

    public FloatIterator iterator() {
        return new FloatProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0.0f) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatProgression floats = (FloatProgression)o;
        if (Float.compare(floats.end, this.end) != 0) {
            return false;
        }
        if (Float.compare(floats.increment, this.increment) != 0) {
            return false;
        }
        return Float.compare(floats.start, this.start) == 0;
    }

    public int hashCode() {
        int result = this.start != 0.0f ? Float.floatToIntBits(this.start) : 0;
        result = 31 * result + (this.end != 0.0f ? Float.floatToIntBits(this.end) : 0);
        result = 31 * result + (this.increment != 0.0f ? Float.floatToIntBits(this.increment) : 0);
        return result;
    }
}

