/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.LongIterator;
import jet.LongProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class LongProgression
implements Progression<Long> {
    private final long start;
    private final long end;
    private final long increment;

    public LongProgression(long start, long end, long increment) {
        if (increment == 0L) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Long getStart() {
        return this.start;
    }

    @Override
    public Long getEnd() {
        return this.end;
    }

    @Override
    public Long getIncrement() {
        return this.increment;
    }

    public LongIterator iterator() {
        return new LongProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0L) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongProgression longs = (LongProgression)o;
        if (this.end != longs.end) {
            return false;
        }
        if (this.increment != longs.increment) {
            return false;
        }
        return this.start == longs.start;
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.increment ^ this.increment >>> 32);
        return result;
    }
}

