/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.Progression;
import jet.Range;
import jet.ShortIterator;
import jet.ShortProgressionIterator;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class ShortRange
implements Range<Short>,
Progression<Short> {
    public static final ShortRange EMPTY = new ShortRange(1, 0);
    private final short start;
    private final short end;

    public ShortRange(short start, short end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Short item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public boolean contains(short item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Short getStart() {
        return this.start;
    }

    @Override
    public Short getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return 1;
    }

    public ShortIterator iterator() {
        return new ShortProgressionIterator(this.start, this.end, 1);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortRange range = (ShortRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }
}

