/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.Interner;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorForObject;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DescriptorSerializer {
    private static final DescriptorRenderer RENDERER = DescriptorRenderer.STARTS_FROM_NAME;
    private static final Comparator<DeclarationDescriptor> DESCRIPTOR_COMPARATOR = new Comparator<DeclarationDescriptor>(){

        @Override
        public int compare(DeclarationDescriptor o1, DeclarationDescriptor o2) {
            int names = o1.getName().compareTo(o2.getName());
            if (names != 0) {
                return names;
            }
            String o1String = RENDERER.render(o1);
            String o2String = RENDERER.render(o2);
            return o1String.compareTo(o2String);
        }
    };
    private final NameTable nameTable;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;

    public DescriptorSerializer() {
        this(SerializerExtension.DEFAULT);
    }

    public DescriptorSerializer(@NotNull SerializerExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "<init>"));
        }
        this(new NameTable(), new Interner<TypeParameterDescriptor>(), extension);
    }

    private DescriptorSerializer(NameTable nameTable, Interner<TypeParameterDescriptor> typeParameters, SerializerExtension extension) {
        this.nameTable = nameTable;
        this.typeParameters = typeParameters;
        this.extension = extension;
    }

    private DescriptorSerializer createChildSerializer() {
        return new DescriptorSerializer(this.nameTable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension);
    }

    @NotNull
    public NameTable getNameTable() {
        NameTable nameTable = this.nameTable;
        if (nameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getNameTable"));
        }
        return nameTable;
    }

    @NotNull
    public ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classProto"));
        }
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner());
        builder.setFlags(flags);
        builder.setFqName(this.getClassId(classDescriptor));
        DescriptorSerializer local = this.createChildSerializer();
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        if (this.extension.hasSupertypes(classDescriptor)) {
            for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
                builder.addSupertype(local.type(supertype));
            }
        }
        if ((primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.setPrimaryConstructor(local.callableProto(primaryConstructor));
        }
        for (DeclarationDescriptor descriptor : DescriptorSerializer.sort(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors())) {
            CallableMemberDescriptor callableMemberDescriptor;
            if (!(descriptor instanceof CallableMemberDescriptor) || (callableMemberDescriptor = (CallableMemberDescriptor)descriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            builder.addMember(local.callableProto(callableMemberDescriptor));
        }
        Collection<DeclarationDescriptor> nestedClasses = classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors();
        for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.sort(nestedClasses)) {
            ClassDescriptor nestedClass = (ClassDescriptor)declarationDescriptor;
            int nameIndex = this.nameTable.getSimpleNameIndex(nestedClass.getName());
            builder.addNestedClassName(nameIndex);
        }
        for (ClassDescriptor classDescriptor2 : DescriptorSerializer.sort(classDescriptor.getUnsubstitutedInnerClassesScope().getObjectDescriptors())) {
            int nameIndex = this.nameTable.getSimpleNameIndex(classDescriptor2.getName());
            builder.addNestedObjectName(nameIndex);
        }
        if (classDescriptor.getClassObjectDescriptor() != null) {
            builder.setClassObjectPresent(true);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            for (ClassDescriptor classDescriptor3 : DescriptorUtils.getEnumEntriesScope(classDescriptor).getObjectDescriptors()) {
                if (classDescriptor3.getKind() != ClassKind.ENUM_ENTRY) continue;
                builder.addEnumEntry(this.nameTable.getSimpleNameIndex(classDescriptor3.getName()));
            }
        }
        ProtoBuf.Class.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Callable.Builder callableProto(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableProto"));
        }
        ProtoBuf.Callable.Builder builder = ProtoBuf.Callable.newBuilder();
        DescriptorSerializer local = this.createChildSerializer();
        boolean hasGetter = false;
        boolean hasSetter = false;
        if (descriptor instanceof PropertyDescriptor) {
            PropertySetterDescriptor setter;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            int propertyFlags = Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(propertyDescriptor), propertyDescriptor.getVisibility(), propertyDescriptor.getModality(), false);
            PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
            if (getter != null) {
                hasGetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(getter);
                if (accessorFlags != propertyFlags) {
                    builder.setGetterFlags(accessorFlags);
                }
            }
            if ((setter = propertyDescriptor.getSetter()) != null) {
                hasSetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(setter);
                if (accessorFlags != propertyFlags) {
                    builder.setSetterFlags(accessorFlags);
                }
                if (!setter.isDefault()) {
                    for (ValueParameterDescriptor valueParameterDescriptor : setter.getValueParameters()) {
                        builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
                    }
                }
            }
        }
        builder.setFlags(Flags.getCallableFlags(DescriptorSerializer.hasAnnotations(descriptor), descriptor.getVisibility(), descriptor.getModality(), descriptor.getKind(), DescriptorSerializer.callableKind(descriptor), descriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor).isInline(), hasGetter, hasSetter));
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        if (receiverParameter != null) {
            builder.setReceiverType(local.type(receiverParameter.getType()));
        }
        builder.setName(this.nameTable.getSimpleNameIndex(descriptor.getName()));
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        builder.setReturnType(local.type(DescriptorSerializer.getSerializableReturnType(descriptor.getReturnType())));
        this.extension.serializeCallable(descriptor, builder, this.nameTable);
        ProtoBuf.Callable.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableProto"));
        }
        return builder2;
    }

    @NotNull
    private static JetType getSerializableReturnType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getSerializableReturnType"));
        }
        JetType jetType = DescriptorSerializer.isSerializableType(type) ? type : KotlinBuiltIns.getInstance().getAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getSerializableReturnType"));
        }
        return jetType;
    }

    private static boolean isSerializableType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "isSerializableType"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor instanceof TypeParameterDescriptor) {
            return true;
        }
        if (descriptor instanceof ClassDescriptor) {
            for (TypeProjection projection : type.getArguments()) {
                if (DescriptorSerializer.isSerializableType(projection.getType())) continue;
                return false;
            }
            return DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)descriptor);
        }
        throw new IllegalStateException("Unknown type constructor: " + type);
    }

    private static int getAccessorFlags(@NotNull PropertyAccessorDescriptor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getAccessorFlags"));
        }
        return Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault());
    }

    private static ProtoBuf.Callable.CallableKind callableKind(CallableMemberDescriptor descriptor) {
        if (descriptor instanceof VariableDescriptorForObject) {
            return ProtoBuf.Callable.CallableKind.OBJECT_PROPERTY;
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            return propertyDescriptor.isVar() ? ProtoBuf.Callable.CallableKind.VAR : ProtoBuf.Callable.CallableKind.VAL;
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return ProtoBuf.Callable.CallableKind.CONSTRUCTOR;
        }
        assert (descriptor instanceof FunctionDescriptor) : "Unknown descriptor class: " + descriptor.getClass();
        return ProtoBuf.Callable.CallableKind.FUN;
    }

    @NotNull
    private ProtoBuf.Callable.ValueParameter.Builder valueParameter(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "valueParameter"));
        }
        ProtoBuf.Callable.ValueParameter.Builder builder = ProtoBuf.Callable.ValueParameter.newBuilder();
        builder.setFlags(Flags.getValueParameterFlags(DescriptorSerializer.hasAnnotations(descriptor), descriptor.declaresDefaultValue()));
        builder.setName(this.nameTable.getSimpleNameIndex(descriptor.getName()));
        builder.setType(this.type(descriptor.getType()));
        JetType varargElementType = descriptor.getVarargElementType();
        if (varargElementType != null) {
            builder.setVarargElementType(this.type(varargElementType));
        }
        this.extension.serializeValueParameter(descriptor, builder, this.nameTable);
        ProtoBuf.Callable.ValueParameter.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "valueParameter"));
        }
        return builder2;
    }

    private ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Variance variance;
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        builder.setName(this.nameTable.getSimpleNameIndex(typeParameter.getName()));
        if (typeParameter.isReified()) {
            builder.setReified(true);
        }
        if ((variance = DescriptorSerializer.variance(typeParameter.getVariance())) != ProtoBuf.TypeParameter.Variance.INV) {
            builder.setVariance(variance);
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            builder.addUpperBound(this.type(upperBound));
        }
        return builder;
    }

    private static ProtoBuf.TypeParameter.Variance variance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return ProtoBuf.TypeParameter.Variance.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.OUT;
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    @NotNull
    public ProtoBuf.Type.Builder type(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "type"));
        }
        assert (!type.isError()) : "Can't serialize error types: " + type;
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        builder.setConstructor(this.typeConstructor(type.getConstructor()));
        for (TypeProjection projection : type.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type.isNullable()) {
            builder.setNullable(true);
        }
        ProtoBuf.Type.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "type"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Type.Argument.Builder typeArgument(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeArgument"));
        }
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.projection(typeProjection.getProjectionKind());
        if (projection != ProtoBuf.Type.Argument.Projection.INV) {
            builder.setProjection(projection);
        }
        builder.setType(this.type(typeProjection.getType()));
        ProtoBuf.Type.Argument.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeArgument"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Type.Constructor.Builder typeConstructor(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeConstructor"));
        }
        ProtoBuf.Type.Constructor.Builder builder = ProtoBuf.Type.Constructor.newBuilder();
        ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor instanceof TypeParameterDescriptor || declarationDescriptor instanceof ClassDescriptor) : "Unknown declaration descriptor: " + typeConstructor;
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            builder.setKind(ProtoBuf.Type.Constructor.Kind.TYPE_PARAMETER);
            builder.setId(this.getTypeParameterId(typeParameterDescriptor));
        } else {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            builder.setId(this.getClassId(classDescriptor));
        }
        ProtoBuf.Type.Constructor.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeConstructor"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull NamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(descriptor.getMemberScope().getAllDescriptors())) {
            if (!(declaration instanceof PropertyDescriptor) && !(declaration instanceof FunctionDescriptor)) continue;
            builder.addMember(this.callableProto((CallableMemberDescriptor)declaration));
        }
        ProtoBuf.Package.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder2;
    }

    @NotNull
    private static ProtoBuf.Type.Argument.Projection projection(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
        }
        switch (projectionKind) {
            case INVARIANT: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.INV;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case IN_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.IN;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case OUT_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.OUT;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
        }
        throw new IllegalStateException("Unknown projectionKind: " + (Object)((Object)projectionKind));
    }

    private int getClassId(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getClassId"));
        }
        return this.nameTable.getFqNameIndex(descriptor);
    }

    private int getTypeParameterId(@NotNull TypeParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getTypeParameterId"));
        }
        return this.typeParameters.intern(descriptor);
    }

    private static boolean hasAnnotations(Annotated descriptor) {
        return !descriptor.getAnnotations().isEmpty();
    }

    @NotNull
    public static <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "sort"));
        }
        ArrayList<T> result = new ArrayList<T>(descriptors);
        Collections.sort(result, DESCRIPTOR_COMPARATOR);
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "sort"));
        }
        return arrayList;
    }
}

