/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;

public class LocalDeclarationInstruction
extends InstructionWithNext {
    private final Pseudocode body;
    private Instruction sink;

    public LocalDeclarationInstruction(@NotNull JetElement element, Pseudocode body) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/LocalDeclarationInstruction", "<init>"));
        }
        super(element);
        this.body = body;
    }

    public Pseudocode getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        if (this.sink != null) {
            ArrayList<Instruction> instructions = Lists.newArrayList(this.sink);
            instructions.addAll(super.getNextInstructions());
            ArrayList<Instruction> arrayList = instructions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalDeclarationInstruction", "getNextInstructions"));
            }
            return arrayList;
        }
        Collection<Instruction> collection = super.getNextInstructions();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalDeclarationInstruction", "getNextInstructions"));
        }
        return collection;
    }

    public void setSink(SubroutineSinkInstruction sink) {
        this.sink = this.outgoingEdgeTo(sink);
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitLocalDeclarationInstruction(this);
    }

    public String toString() {
        return "d(" + this.element.getText() + ")";
    }

    @Override
    protected Instruction createCopy() {
        return new LocalDeclarationInstruction((JetDeclaration)this.element, this.body);
    }
}

