/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;

public class ThrowExceptionInstruction
extends AbstractJumpInstruction
implements JetElementInstruction {
    private final JetThrowExpression expression;

    public ThrowExceptionInstruction(@NotNull JetThrowExpression expression, @NotNull Label errorLabel) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/ThrowExceptionInstruction", "<init>"));
        }
        if (errorLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLabel", "org/jetbrains/jet/lang/cfg/pseudocode/ThrowExceptionInstruction", "<init>"));
        }
        super(errorLabel);
        this.expression = expression;
    }

    @Override
    @NotNull
    public JetExpression getElement() {
        JetThrowExpression jetThrowExpression = this.expression;
        if (jetThrowExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ThrowExceptionInstruction", "getElement"));
        }
        return jetThrowExpression;
    }

    public String toString() {
        return "throw (" + this.expression.getText() + ")";
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitThrowExceptionInstruction(this);
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLabel", "org/jetbrains/jet/lang/cfg/pseudocode/ThrowExceptionInstruction", "createCopy"));
        }
        return new ThrowExceptionInstruction(this.expression, newLabel);
    }
}

