/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetCatchClause
extends JetElementImpl {
    public JetCatchClause(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetCatchClause", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetCatchClause", "accept"));
        }
        visitor.visitCatchSection(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetCatchClause", "accept"));
        }
        return visitor.visitCatchSection(this, data2);
    }

    @IfNotParsed
    @Nullable
    public JetParameterList getParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @IfNotParsed
    @Nullable
    public JetParameter getCatchParameter() {
        JetParameterList list2 = this.getParameterList();
        if (list2 == null) {
            return null;
        }
        List<JetParameter> parameters = list2.getParameters();
        return parameters.size() == 1 ? parameters.get(0) : null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getCatchBody() {
        return this.findChildByClass(JetExpression.class);
    }
}

