/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetClassElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lexer.JetTokens;

public class JetClass
extends JetTypeParameterListOwnerStub<PsiJetClassStub>
implements JetClassOrObject {
    public JetClass(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetClass", "<init>"));
        }
        super(node);
    }

    public JetClass(@NotNull PsiJetClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetClass", "<init>"));
        }
        super(stub, JetStubElementTypes.CLASS);
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        JetClassBody body = (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
        if (body == null) {
            List<JetDeclaration> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getDeclarations"));
            }
            return list2;
        }
        List<JetDeclaration> list3 = body.getDeclarations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getDeclarations"));
        }
        return list3;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetClass", "accept"));
        }
        visitor.visitClass(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetClass", "accept"));
        }
        return visitor.visitClass(this, data2);
    }

    @Nullable
    public JetParameterList getPrimaryConstructorParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @NotNull
    public List<JetParameter> getPrimaryConstructorParameters() {
        JetParameterList list2 = this.getPrimaryConstructorParameterList();
        if (list2 == null) {
            List<JetParameter> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getPrimaryConstructorParameters"));
            }
            return list3;
        }
        List<JetParameter> list4 = list2.getParameters();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getPrimaryConstructorParameters"));
        }
        return list4;
    }

    @Override
    @Nullable
    public JetDelegationSpecifierList getDelegationSpecifierList() {
        return (JetDelegationSpecifierList)this.findChildByType(JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetDelegationSpecifierList list2 = this.getDelegationSpecifierList();
        List<JetDelegationSpecifier> list3 = list2 != null ? list2.getDelegationSpecifiers() : Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getDelegationSpecifiers"));
        }
        return list3;
    }

    @Nullable
    public JetModifierList getPrimaryConstructorModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.PRIMARY_CONSTRUCTOR_MODIFIER_LIST);
    }

    @Override
    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        JetClassBody body = this.getBody();
        if (body == null) {
            List<JetClassInitializer> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getAnonymousInitializers"));
            }
            return list2;
        }
        List<JetClassInitializer> list3 = body.getAnonymousInitializers();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getAnonymousInitializers"));
        }
        return list3;
    }

    @Override
    public boolean hasPrimaryConstructor() {
        return this.getPrimaryConstructorParameterList() != null;
    }

    @Override
    public JetObjectDeclarationName getNameAsDeclaration() {
        return (JetObjectDeclarationName)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION_NAME);
    }

    @Override
    public JetClassBody getBody() {
        return (JetClassBody)this.findChildByType(JetNodeTypes.CLASS_BODY);
    }

    @Nullable
    public JetClassObject getClassObject() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.getClassObject();
    }

    public List<JetProperty> getProperties() {
        JetClassBody body = this.getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getProperties();
    }

    public boolean isTrait() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            return stub.isTrait();
        }
        return this.findChildByType(JetTokens.TRAIT_KEYWORD) != null;
    }

    public boolean isEnum() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            return stub.isEnumClass();
        }
        return this.hasModifier(JetTokens.ENUM_KEYWORD);
    }

    public boolean isAnnotation() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            return stub.isAnnotation();
        }
        return this.hasModifier(JetTokens.ANNOTATION_KEYWORD);
    }

    public boolean isInner() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            return stub.isInner();
        }
        return this.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        JetClassElementType jetClassElementType = JetStubElementTypes.CLASS;
        if (jetClassElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getElementType"));
        }
        return jetClassElementType;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        JetPsiUtil.deleteClass(this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && fq1.equals(fq2);
        }
        return false;
    }

    @Nullable
    private String getQualifiedName() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            FqName fqName = stub.getFqName();
            return fqName == null ? null : fqName.asString();
        }
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            parts.add(current.getName());
            current = PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getNamespaceHeader().getQualifiedName();
        if (!fileQualifiedName.isEmpty()) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse(parts);
        return StringUtil.join(parts, ".");
    }

    @NotNull
    public List<String> getSuperNames() {
        PsiJetClassStub stub = (PsiJetClassStub)this.getStub();
        if (stub != null) {
            List<String> list2 = stub.getSuperNames();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getSuperNames"));
            }
            return list2;
        }
        List<JetDelegationSpecifier> specifiers = this.getDelegationSpecifiers();
        if (specifiers.size() == 0) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getSuperNames"));
            }
            return list3;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (JetDelegationSpecifier specifier : specifiers) {
            String referencedName;
            JetUserType superType = specifier.getTypeAsUserType();
            if (superType == null || (referencedName = superType.getReferencedName()) == null) continue;
            this.addSuperName(result, referencedName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClass", "getSuperNames"));
        }
        return arrayList;
    }

    private void addSuperName(List<String> result, String referencedName) {
        JetImportDirective directive;
        result.add(referencedName);
        if (this.getContainingFile() instanceof JetFile && (directive = ((JetFile)this.getContainingFile()).findImportByAlias(referencedName)) != null) {
            JetExpression reference = directive.getImportedReference();
            while (reference instanceof JetDotQualifiedExpression) {
                reference = ((JetDotQualifiedExpression)reference).getSelectorExpression();
            }
            if (reference instanceof JetSimpleNameExpression) {
                result.add(((JetSimpleNameExpression)reference).getReferencedName());
            }
        }
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }
}

