/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.parsing.JetExpressionParsing;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetTokens;

public class JetSimpleNameExpression
extends JetReferenceExpression {
    public static final TokenSet REFERENCE_TOKENS = TokenSet.orSet(JetTokens.LABELS, TokenSet.create(JetTokens.IDENTIFIER, JetTokens.FIELD_IDENTIFIER, JetTokens.THIS_KEYWORD, JetTokens.SUPER_KEYWORD));

    public JetSimpleNameExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public JetExpression getReceiverExpression() {
        JetCallExpression callExpression;
        PsiElement parent = this.getParent();
        if (parent instanceof JetQualifiedExpression && !this.isImportDirectiveExpression()) {
            JetExpression receiverExpression = ((JetQualifiedExpression)parent).getReceiverExpression();
            if (receiverExpression != this) {
                return receiverExpression;
            }
        } else if (parent instanceof JetCallExpression && (parent = (callExpression = (JetCallExpression)parent).getParent()) instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent;
            return qualifiedExpression.getReceiverExpression();
        }
        return null;
    }

    public boolean isImportDirectiveExpression() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof JetImportDirective || parent.getParent() instanceof JetImportDirective;
    }

    @NotNull
    public String getReferencedName() {
        String text = this.getReferencedNameElement().getNode().getText();
        String string = JetPsiUtil.unquoteIdentifierOrFieldReference(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "getReferencedName"));
        }
        return string;
    }

    @NotNull
    public Name getReferencedNameAsName() {
        String name = this.getReferencedName();
        Name name2 = Name.identifierNoValidate(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "getReferencedNameAsName"));
        }
        return name2;
    }

    @NotNull
    public PsiElement getReferencedNameElement() {
        PsiElement element = this.findChildByType(REFERENCE_TOKENS);
        if (element == null) {
            element = this.findChildByType(JetExpressionParsing.ALL_OPERATIONS);
        }
        if (element != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "getReferencedNameElement"));
            }
            return psiElement;
        }
        JetSimpleNameExpression jetSimpleNameExpression = this;
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "getReferencedNameElement"));
        }
        return jetSimpleNameExpression;
    }

    @Nullable
    public PsiElement getIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    @IfNotParsed
    @Nullable
    public IElementType getReferencedNameElementType() {
        return this.getReferencedNameElement().getNode().getElementType();
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "accept"));
        }
        visitor.visitSimpleNameExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetSimpleNameExpression", "accept"));
        }
        return visitor.visitSimpleNameExpression(this, data2);
    }
}

