/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetCodeFragmentImpl;
import org.jetbrains.jet.lang.psi.JetTypeCodeFragment;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeCodeFragmentImpl
extends JetCodeFragmentImpl
implements JetTypeCodeFragment {
    public JetTypeCodeFragmentImpl(Project project, String name, CharSequence text, PsiElement context) {
        super(project, name, text, JetNodeTypes.TYPE_CODE_FRAGMENT, context);
    }

    @Override
    @Nullable
    public JetType getType() {
        JetType type = null;
        for (PsiElement child : this.getChildren()) {
            IElementType elementType = child.getNode().getElementType();
            if (elementType == JetNodeTypes.TYPE_CODE_FRAGMENT) {
                for (PsiElement grChild : child.getChildren()) {
                    if (grChild instanceof JetTypeReference) {
                        if (grChild.getText().isEmpty()) continue;
                        type = KotlinBuiltIns.getInstance().getAnyType();
                        continue;
                    }
                    if (JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(elementType)) continue;
                    return null;
                }
                continue;
            }
            if (JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(elementType)) continue;
            return null;
        }
        return type;
    }
}

