/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.stubs.PsiJetPropertyStub;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetPropertyStubImpl
extends StubBase<JetProperty>
implements PsiJetPropertyStub {
    private final StringRef name;
    private final boolean isVar;
    private final boolean isTopLevel;
    private final FqName topFQName;
    private final StringRef typeText;
    private final StringRef inferenceBodyText;

    public PsiJetPropertyStubImpl(IStubElementType elementType, StubElement parent, StringRef name, boolean isVar, boolean isTopLevel, @Nullable FqName topFQName, StringRef typeText, StringRef inferenceBodyText) {
        super(parent, elementType);
        if (isTopLevel && topFQName == null) {
            throw new IllegalArgumentException("topFQName shouldn't be null for top level properties");
        }
        this.name = name;
        this.isVar = isVar;
        this.isTopLevel = isTopLevel;
        this.topFQName = topFQName;
        this.typeText = typeText;
        this.inferenceBodyText = inferenceBodyText;
    }

    public PsiJetPropertyStubImpl(IStubElementType elementType, StubElement parent, String name, boolean isVal, boolean isTopLevel, @Nullable FqName topFQName, String typeText, String inferenceBodyText) {
        this(elementType, parent, StringRef.fromString(name), isVal, isTopLevel, topFQName, StringRef.fromString(typeText), StringRef.fromString(inferenceBodyText));
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    @Nullable
    public FqName getTopFQName() {
        return this.topFQName;
    }

    @Override
    public String getTypeText() {
        return StringRef.toString(this.typeText);
    }

    @Override
    public String getInferenceBodyText() {
        return StringRef.toString(this.inferenceBodyText);
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetPropertyStubImpl[");
        builder.append(this.isVar() ? "var " : "val ");
        if (this.isTopLevel()) {
            assert (this.topFQName != null);
            builder.append("top ").append("topFQName=").append(this.topFQName.toString()).append(" ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" typeText=").append(this.getTypeText());
        builder.append(" bodyText=").append(this.getInferenceBodyText());
        builder.append("]");
        return builder.toString();
    }
}

