/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverloadUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;

public class OverloadResolver {
    private TopDownAnalysisContext context;
    private BindingTrace trace;

    public void setContext(TopDownAnalysisContext context) {
        this.context = context;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process() {
        this.checkOverloads();
    }

    private void checkOverloads() {
        Pair<MultiMap<ClassDescriptor, ConstructorDescriptor>, MultiMap<Key, ConstructorDescriptor>> pair = this.constructorsGrouped();
        MultiMap inClasses = (MultiMap)pair.first;
        MultiMap inNamespaces = (MultiMap)pair.second;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), entry.getKey(), inClasses.get(entry.getValue()));
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), (JetClassOrObject)((Object)entry.getKey()), inClasses.get(entry.getValue()));
        }
        this.checkOverloadsInANamespace(inNamespaces);
    }

    private Pair<MultiMap<ClassDescriptor, ConstructorDescriptor>, MultiMap<Key, ConstructorDescriptor>> constructorsGrouped() {
        MultiMap inClasses = MultiMap.create();
        MultiMap inNamespaces = MultiMap.create();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            MutableClassDescriptor klass = entry.getValue();
            DeclarationDescriptor containingDeclaration = klass.getContainingDeclaration();
            if (containingDeclaration instanceof NamespaceDescriptor) {
                NamespaceDescriptor namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
                inNamespaces.put(new Key(namespaceDescriptor, klass.getName()), klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                inClasses.put(classDescriptor, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor) continue;
            throw new IllegalStateException();
        }
        return Pair.create(inClasses, inNamespaces);
    }

    private void checkOverloadsInANamespace(MultiMap<Key, ConstructorDescriptor> inNamespaces) {
        NamespaceDescriptor namespaceDescriptor;
        DeclarationDescriptor containingDeclaration;
        MultiMap<Key, CallableMemberDescriptor> functionsByName = MultiMap.create();
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : this.context.getFunctions().values()) {
            containingDeclaration = simpleFunctionDescriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof NamespaceDescriptor)) continue;
            namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            functionsByName.putValue(new Key(namespaceDescriptor, simpleFunctionDescriptor.getName()), simpleFunctionDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : this.context.getProperties().values()) {
            containingDeclaration = propertyDescriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof NamespaceDescriptor)) continue;
            namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            functionsByName.putValue(new Key(namespaceDescriptor, propertyDescriptor.getName()), propertyDescriptor);
        }
        for (Map.Entry entry : inNamespaces.entrySet()) {
            functionsByName.putValues((Key)entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName(((Key)entry.getKey()).getFunctionName(), (Collection)entry.getValue(), ((Key)entry.getKey()).getNamespace());
        }
    }

    private String nameForErrorMessage(ClassDescriptor classDescriptor, JetClassOrObject jetClass) {
        String name = jetClass.getName();
        if (name != null) {
            return name;
        }
        if (jetClass instanceof JetObjectDeclaration) {
            name = classDescriptor.getContainingDeclaration().getName().asString();
            return "class object " + name;
        }
        return "<unknown>";
    }

    private void checkOverloadsInAClass(MutableClassDescriptor classDescriptor, JetClassOrObject klass, Collection<ConstructorDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> functionsByName = MultiMap.create();
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            MutableClassDescriptor classObjectDescriptor = (MutableClassDescriptor)classDescriptor.getClassObjectDescriptor();
            assert (classObjectDescriptor != null);
            for (CallableMemberDescriptor memberDescriptor : classObjectDescriptor.getDeclaredCallableMembers()) {
                functionsByName.putValue(memberDescriptor.getName(), memberDescriptor);
            }
        }
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName.putValue(callableMemberDescriptor.getName(), callableMemberDescriptor);
        }
        for (ConstructorDescriptor constructorDescriptor : nestedClassConstructors) {
            functionsByName.putValue(constructorDescriptor.getContainingDeclaration().getName(), constructorDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Name)entry.getKey(), (Collection)entry.getValue(), this.nameForErrorMessage(classDescriptor, klass));
        }
    }

    private void checkOverloadsWithSameName(@NotNull Name name, Collection<CallableMemberDescriptor> functions, @NotNull String functionContainer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsWithSameName"));
        }
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsWithSameName"));
        }
        if (functions.size() == 1) {
            return;
        }
        Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = this.findRedeclarations(functions);
        this.reportRedeclarations(functionContainer, redeclarations);
    }

    @NotNull
    private Set<Pair<JetDeclaration, CallableMemberDescriptor>> findRedeclarations(@NotNull Collection<CallableMemberDescriptor> functions) {
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = Sets.newHashSet();
        for (CallableMemberDescriptor member : functions) {
            for (CallableMemberDescriptor member2 : functions) {
                JetDeclaration jetDeclaration;
                OverloadUtil.OverloadCompatibilityInfo overloadable;
                if (member == member2 || (overloadable = OverloadUtil.isOverloadable(member, member2)).isSuccess() || (jetDeclaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), member)) == null) continue;
                redeclarations.add(Pair.create(jetDeclaration, member));
            }
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> hashSet = redeclarations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        return hashSet;
    }

    private void reportRedeclarations(@NotNull String functionContainer, @NotNull Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        if (redeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarations", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        for (Pair<JetDeclaration, CallableMemberDescriptor> redeclaration : redeclarations) {
            CallableMemberDescriptor memberDescriptor = redeclaration.getSecond();
            JetDeclaration jetDeclaration = redeclaration.getFirst();
            if (memberDescriptor instanceof PropertyDescriptor) {
                this.trace.report(Errors.REDECLARATION.on(jetDeclaration, memberDescriptor.getName().asString()));
                continue;
            }
            this.trace.report(Errors.CONFLICTING_OVERLOADS.on(jetDeclaration, memberDescriptor, functionContainer));
        }
    }

    private static class Key
    extends Pair<String, Name> {
        Key(String namespace, Name name) {
            super(namespace, name);
        }

        Key(NamespaceDescriptor namespaceDescriptor, Name name) {
            this(DescriptorUtils.getFQName(namespaceDescriptor).asString(), name);
        }

        public String getNamespace() {
            return (String)this.first;
        }

        public Name getFunctionName() {
            return (Name)this.second;
        }
    }
}

