/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private DataFlowInfo outerDataFlowInfo = DataFlowInfo.EMPTY;
    private final Map<JetClass, MutableClassDescriptor> classes = Maps.newLinkedHashMap();
    private final Map<JetObjectDeclaration, MutableClassDescriptor> objects = Maps.newLinkedHashMap();
    protected final Map<JetFile, NamespaceDescriptorImpl> namespaceDescriptors = Maps.newHashMap();
    private List<MutableClassDescriptorLite> classesTopologicalOrder = null;
    private final Map<JetDeclaration, JetScope> declaringScopes = Maps.newHashMap();
    private final Map<JetNamedFunction, SimpleFunctionDescriptor> functions = Maps.newLinkedHashMap();
    private final Map<JetProperty, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private final Map<JetParameter, PropertyDescriptor> primaryConstructorParameterProperties = Maps.newHashMap();
    private Map<JetDeclaration, CallableMemberDescriptor> members = null;
    protected final Map<JetFile, WritableScope> namespaceScopes = Maps.newHashMap();
    public final Map<JetDeclarationContainer, DeclarationDescriptor> forDeferredResolver = Maps.newHashMap();
    public final Map<JetDeclarationContainer, JetScope> normalScope = Maps.newHashMap();
    private final Map<JetScript, ScriptDescriptor> scripts = Maps.newLinkedHashMap();
    private final Map<JetScript, WritableScope> scriptScopes = Maps.newHashMap();
    private StringBuilder debugOutput;
    private TopDownAnalysisParameters topDownAnalysisParameters;

    @Override
    public void setTopDownAnalysisParameters(TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    public TopDownAnalysisParameters getTopDownAnalysisParameters() {
        return this.topDownAnalysisParameters;
    }

    public void debug(Object message) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message).append("\n");
        }
    }

    void printDebugOutput(PrintStream out) {
        if (this.debugOutput != null) {
            out.print(this.debugOutput);
        }
    }

    @Override
    public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
        boolean result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "completeAnalysisNeeded"));
        }
        PsiFile containingFile = element.getContainingFile();
        boolean bl = result = containingFile != null && this.topDownAnalysisParameters.getAnalyzeCompletely().apply(containingFile);
        if (!result) {
            this.debug(containingFile);
        }
        return result;
    }

    @Override
    public Map<JetClass, MutableClassDescriptor> getClasses() {
        return this.classes;
    }

    @Override
    public Map<JetObjectDeclaration, MutableClassDescriptor> getObjects() {
        return this.objects;
    }

    public Map<JetFile, WritableScope> getNamespaceScopes() {
        return this.namespaceScopes;
    }

    public Map<JetFile, NamespaceDescriptorImpl> getNamespaceDescriptors() {
        return this.namespaceDescriptors;
    }

    @Override
    public Collection<JetFile> getFiles() {
        return this.namespaceDescriptors.keySet();
    }

    @Override
    @NotNull
    public Map<JetScript, ScriptDescriptor> getScripts() {
        Map<JetScript, ScriptDescriptor> map = this.scripts;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "getScripts"));
        }
        return map;
    }

    @Override
    @NotNull
    public Map<JetScript, WritableScope> getScriptScopes() {
        Map<JetScript, WritableScope> map = this.scriptScopes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "getScriptScopes"));
        }
        return map;
    }

    public Map<JetParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<JetProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    public Function<JetDeclaration, JetScope> getDeclaringScopes() {
        return Functions.forMap(this.declaringScopes);
    }

    public void registerDeclaringScope(@NotNull JetDeclaration declaration, @NotNull JetScope scope) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "registerDeclaringScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "registerDeclaringScope"));
        }
        this.declaringScopes.put(declaration, scope);
    }

    @Override
    public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    public Map<JetDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        return this.members;
    }

    @NotNull
    public List<MutableClassDescriptorLite> getClassesTopologicalOrder() {
        List<MutableClassDescriptorLite> list2 = this.classesTopologicalOrder;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "getClassesTopologicalOrder"));
        }
        return list2;
    }

    public void setClassesTopologicalOrder(@NotNull List<MutableClassDescriptorLite> classesTopologicalOrder) {
        if (classesTopologicalOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesTopologicalOrder", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "setClassesTopologicalOrder"));
        }
        this.classesTopologicalOrder = classesTopologicalOrder;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.outerDataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "getOuterDataFlowInfo"));
        }
        return dataFlowInfo;
    }

    public void setOuterDataFlowInfo(@NotNull DataFlowInfo outerDataFlowInfo) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/jet/lang/resolve/TopDownAnalysisContext", "setOuterDataFlowInfo"));
        }
        this.outerDataFlowInfo = outerDataFlowInfo;
    }
}

