/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;

public class TemporaryResolutionResultsCache
implements ResolutionResultsCache {
    private final ResolutionResultsCache parentCache;
    private final ResolutionResultsCacheImpl innerCache;

    public TemporaryResolutionResultsCache(@NotNull ResolutionResultsCache parentCache) {
        if (parentCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCache", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "<init>"));
        }
        assert (parentCache instanceof ResolutionResultsCacheImpl || parentCache instanceof TemporaryResolutionResultsCache) : "Unsupported parent cache: " + parentCache;
        this.parentCache = parentCache;
        this.innerCache = new ResolutionResultsCacheImpl();
    }

    @Override
    public <D extends CallableDescriptor> void recordResolutionResults(@NotNull CallKey callKey, @NotNull ResolutionResultsCache.MemberType<D> memberType, @NotNull OverloadResolutionResultsImpl<D> results) {
        if (callKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callKey", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordResolutionResults"));
        }
        if (memberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordResolutionResults"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordResolutionResults"));
        }
        this.innerCache.recordResolutionResults(callKey, memberType, results);
    }

    @Override
    @Nullable
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> getResolutionResults(@NotNull CallKey callKey, @NotNull ResolutionResultsCache.MemberType<D> memberType) {
        if (callKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callKey", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "getResolutionResults"));
        }
        if (memberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "getResolutionResults"));
        }
        OverloadResolutionResultsImpl<D> results = this.innerCache.getResolutionResults(callKey, memberType);
        if (results != null) {
            return results;
        }
        return this.parentCache.getResolutionResults(callKey, memberType);
    }

    @Override
    public void recordResolutionTrace(@NotNull CallKey callKey, @NotNull DelegatingBindingTrace delegatingTrace) {
        if (callKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callKey", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordResolutionTrace"));
        }
        if (delegatingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingTrace", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordResolutionTrace"));
        }
        this.innerCache.recordResolutionTrace(callKey, delegatingTrace);
    }

    @Override
    @Nullable
    public DelegatingBindingTrace getResolutionTrace(@NotNull CallKey callKey) {
        if (callKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callKey", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "getResolutionTrace"));
        }
        DelegatingBindingTrace trace = this.innerCache.getResolutionTrace(callKey);
        if (trace != null) {
            return trace;
        }
        return this.parentCache.getResolutionTrace(callKey);
    }

    @Override
    public <D extends CallableDescriptor> void recordDeferredComputationForCall(@NotNull CallKey callKey, @NotNull ResolvedCallWithTrace<D> resolvedCall, @NotNull CallCandidateResolutionContext<D> deferredComputation) {
        if (callKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callKey", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordDeferredComputationForCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordDeferredComputationForCall"));
        }
        if (deferredComputation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deferredComputation", "org/jetbrains/jet/lang/resolve/calls/context/TemporaryResolutionResultsCache", "recordDeferredComputationForCall"));
        }
        this.innerCache.recordDeferredComputationForCall(callKey, resolvedCall, deferredComputation);
    }

    @Override
    @Nullable
    public CallCandidateResolutionContext<? extends CallableDescriptor> getDeferredComputation(@Nullable JetExpression expression) {
        CallCandidateResolutionContext<? extends CallableDescriptor> computation = this.innerCache.getDeferredComputation(expression);
        if (computation != null) {
            return computation;
        }
        return this.parentCache.getDeferredComputation(expression);
    }

    @Override
    @Nullable
    public ResolvedCallWithTrace<? extends CallableDescriptor> getCallForArgument(@Nullable JetExpression expression) {
        ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall = this.innerCache.getCallForArgument(expression);
        if (resolvedCall != null) {
            return resolvedCall;
        }
        return this.parentCache.getCallForArgument(expression);
    }

    public void commit() {
        if (this.parentCache instanceof ResolutionResultsCacheImpl) {
            ((ResolutionResultsCacheImpl)this.parentCache).addData(this.innerCache);
            return;
        }
        assert (this.parentCache instanceof TemporaryResolutionResultsCache);
        ((TemporaryResolutionResultsCache)this.parentCache).innerCache.addData(this.innerCache);
    }
}

