/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.constants.NumberValueTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DoubleValueTypeConstructor
extends NumberValueTypeConstructor {
    private final double value;
    private final List<JetType> supertypes;

    public DoubleValueTypeConstructor(double value) {
        this.value = value;
        this.supertypes = Lists.newArrayList(KotlinBuiltIns.getInstance().getDoubleType(), KotlinBuiltIns.getInstance().getFloatType());
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        List<JetType> list2 = this.supertypes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/DoubleValueTypeConstructor", "getSupertypes"));
        }
        return list2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleValueTypeConstructor that = (DoubleValueTypeConstructor)o;
        return Double.compare(that.value, this.value) == 0;
    }
}

