/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.DefaultModuleConfiguration;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class JavaBridgeConfiguration
implements ModuleConfiguration {
    public static final List<ImportPath> DEFAULT_JAVA_IMPORTS = Collections.unmodifiableList(Arrays.asList(new ImportPath("java.lang.*")));
    public static final List<ImportPath> ALL_JAVA_IMPORTS;
    private JavaDescriptorResolver javaDescriptorResolver;

    public void setJavaDescriptorResolver(@NotNull JavaDescriptorResolver javaDescriptorResolver) {
        if (javaDescriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDescriptorResolver", "org/jetbrains/jet/lang/resolve/java/JavaBridgeConfiguration", "setJavaDescriptorResolver"));
        }
        this.javaDescriptorResolver = javaDescriptorResolver;
    }

    @Override
    public void extendNamespaceScope(@NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/jet/lang/resolve/java/JavaBridgeConfiguration", "extendNamespaceScope"));
        }
        if (namespaceMemberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceMemberScope", "org/jetbrains/jet/lang/resolve/java/JavaBridgeConfiguration", "extendNamespaceScope"));
        }
        JetScope javaPackageScope = this.javaDescriptorResolver.getJavaPackageScope(namespaceDescriptor);
        if (javaPackageScope != null) {
            namespaceMemberScope.importScope(javaPackageScope);
        }
        DefaultModuleConfiguration.INSTANCE.extendNamespaceScope(namespaceDescriptor, namespaceMemberScope);
    }

    static {
        ArrayList<ImportPath> allJavaImports = new ArrayList<ImportPath>();
        allJavaImports.addAll(DEFAULT_JAVA_IMPORTS);
        allJavaImports.addAll(DefaultModuleConfiguration.DEFAULT_JET_IMPORTS);
        ALL_JAVA_IMPORTS = Collections.unmodifiableList(allJavaImports);
    }
}

