/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaElementFactory;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaSignatureFormatter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public final class DescriptorResolverUtils {
    private DescriptorResolverUtils() {
    }

    public static boolean isCompiledKotlinPackageClass(@NotNull JavaClass javaClass) {
        FqName fqName;
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isCompiledKotlinPackageClass"));
        }
        if (javaClass.getOriginKind() == JavaClass.OriginKind.COMPILED && (fqName = javaClass.getFqName()) != null && PackageClassUtils.isPackageClassFqName(fqName)) {
            return javaClass.findAnnotation(JvmAnnotationNames.KOTLIN_PACKAGE) != null;
        }
        return false;
    }

    public static boolean isCompiledKotlinClass(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isCompiledKotlinClass"));
        }
        if (javaClass.getOriginKind() == JavaClass.OriginKind.COMPILED) {
            return javaClass.findAnnotation(JvmAnnotationNames.KOTLIN_CLASS) != null;
        }
        return false;
    }

    public static boolean isCompiledKotlinClassOrPackageClass(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isCompiledKotlinClassOrPackageClass"));
        }
        return DescriptorResolverUtils.isCompiledKotlinClass(javaClass) || DescriptorResolverUtils.isCompiledKotlinPackageClass(javaClass);
    }

    @NotNull
    public static FqName fqNameByClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "fqNameByClass"));
        }
        FqName fqName = new FqName(clazz.getCanonicalName());
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "fqNameByClass"));
        }
        return fqName;
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverrides(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, final @NotNull ErrorReporter errorReporter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromSupertypes", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        final HashSet result = new HashSet();
        OverridingUtil.generateOverridesInFunctionGroup(name, membersFromSupertypes, membersFromCurrent, classDescriptor, new OverridingUtil.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                if (fakeOverride == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "addToScope"));
                }
                OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new OverridingUtil.NotInferredVisibilitySink(){

                    @Override
                    public void cannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1$1", "cannotInferVisibility"));
                        }
                        errorReporter.reportCannotInferVisibility(descriptor);
                    }
                });
                result.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                if (fromSuper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "conflict"));
                }
                if (fromCurrent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "conflict"));
                }
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        return hashSet;
    }

    @Nullable
    public static ValueParameterDescriptor getAnnotationParameterByName(@NotNull Name name, @NotNull ClassDescriptor annotationClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        Collection<ConstructorDescriptor> constructors = annotationClass.getConstructors();
        assert (constructors.size() == 1) : "Annotation class descriptor must have only one constructor";
        for (ValueParameterDescriptor parameter : constructors.iterator().next().getValueParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean shouldBeInEnumClassObject(@NotNull JavaMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "shouldBeInEnumClassObject"));
        }
        if (!member.getContainingClass().isEnum()) {
            return false;
        }
        if (member instanceof JavaField && ((JavaField)member).isEnumEntry()) {
            return true;
        }
        if (!(member instanceof JavaMethod)) {
            return false;
        }
        String signature = JavaSignatureFormatter.getInstance().formatMethod((JavaMethod)member);
        return "values()".equals(signature) || "valueOf(java.lang.String)".equals(signature);
    }

    public static boolean isCorrectOwnerForEnumMember(@NotNull ClassOrNamespaceDescriptor ownerDescriptor, @NotNull JavaMember member) {
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isCorrectOwnerForEnumMember"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isCorrectOwnerForEnumMember"));
        }
        return DescriptorUtils.isEnumClassObject(ownerDescriptor) == DescriptorResolverUtils.shouldBeInEnumClassObject(member);
    }

    public static boolean isObjectMethodInInterface(@NotNull JavaMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isObjectMethodInInterface"));
        }
        return member.getContainingClass().isInterface() && member instanceof JavaMethod && DescriptorResolverUtils.isObjectMethod((JavaMethod)member);
    }

    public static boolean isObjectMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isObjectMethod"));
        }
        String signature = JavaSignatureFormatter.getInstance().formatMethod(method);
        return "hashCode()".equals(signature) || "equals(java.lang.Object)".equals(signature) || "toString()".equals(signature);
    }

    @NotNull
    public static Collection<JavaClass> getClassesInPackage(@NotNull JavaPackage javaPackage) {
        if (javaPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaPackage", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getClassesInPackage"));
        }
        Collection<JavaClass> classes = javaPackage.getClasses();
        HashSet<FqName> addedQualifiedNames = new HashSet<FqName>(classes.size());
        ArrayList<JavaClass> result = new ArrayList<JavaClass>(classes.size());
        for (JavaClass javaClass : classes) {
            FqName fqName = javaClass.getFqName();
            if (fqName == null || !addedQualifiedNames.add(fqName)) continue;
            result.add(javaClass);
        }
        ArrayList<JavaClass> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getClassesInPackage"));
        }
        return arrayList;
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "erasure"));
        }
        return DescriptorResolverUtils.erasure(type, JavaTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type, @NotNull JavaTypeSubstitutor substitutor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "erasure"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "erasure"));
        }
        if (type instanceof JavaClassifierType) {
            JavaClassifier classifier = ((JavaClassifierType)type).getClassifier();
            if (classifier instanceof JavaClass) {
                return ((JavaClass)classifier).getDefaultType();
            }
            if (classifier instanceof JavaTypeParameter) {
                JavaTypeParameter typeParameter = (JavaTypeParameter)classifier;
                return DescriptorResolverUtils.typeParameterErasure(typeParameter, new HashSet<JavaTypeParameter>(), substitutor);
            }
            return null;
        }
        if (type instanceof JavaPrimitiveType) {
            return type;
        }
        if (type instanceof JavaArrayType) {
            JavaType erasure = DescriptorResolverUtils.erasure(((JavaArrayType)type).getComponentType(), substitutor);
            return erasure == null ? null : JavaElementFactory.getInstance().createArrayType(erasure);
        }
        if (type instanceof JavaWildcardType) {
            JavaWildcardType wildcardType = (JavaWildcardType)type;
            JavaType bound = wildcardType.getBound();
            if (bound != null && wildcardType.isExtends()) {
                return DescriptorResolverUtils.erasure(bound, substitutor);
            }
            return wildcardType.getTypeProvider().createJavaLangObjectType();
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    @Nullable
    private static JavaType typeParameterErasure(@NotNull JavaTypeParameter typeParameter, @NotNull HashSet<JavaTypeParameter> visited, @NotNull JavaTypeSubstitutor substitutor) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "typeParameterErasure"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "typeParameterErasure"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "typeParameterErasure"));
        }
        Collection<JavaClassifierType> upperBounds = typeParameter.getUpperBounds();
        if (!upperBounds.isEmpty()) {
            JavaClassifier classifier = upperBounds.iterator().next().getClassifier();
            if (classifier instanceof JavaTypeParameter && !visited.contains(classifier)) {
                JavaTypeParameter typeParameterBound = (JavaTypeParameter)classifier;
                visited.add(typeParameterBound);
                JavaType substitutedType = substitutor.substitute(typeParameterBound);
                if (substitutedType != null) {
                    return DescriptorResolverUtils.erasure(substitutedType);
                }
                return DescriptorResolverUtils.typeParameterErasure(typeParameterBound, visited, substitutor);
            }
            if (classifier instanceof JavaClass) {
                return ((JavaClass)classifier).getDefaultType();
            }
        }
        return typeParameter.getTypeProvider().createJavaLangObjectType();
    }

    @NotNull
    public static Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> recreateTypeParametersAndReturnMapping(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> result = new LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>();
        for (TypeParameterDescriptor typeParameter : originalParameters) {
            result.put(typeParameter, TypeParameterDescriptorImpl.createForFurtherModification(newOwner == null ? typeParameter.getContainingDeclaration() : newOwner, typeParameter.getAnnotations(), typeParameter.isReified(), typeParameter.getVariance(), typeParameter.getName(), typeParameter.getIndex()));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static TypeSubstitutor createSubstitutorForTypeParameters(@NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters) {
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "createSubstitutorForTypeParameters"));
        }
        HashMap<TypeConstructor, TypeProjection> typeSubstitutionContext = new HashMap<TypeConstructor, TypeProjection>();
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameter : originalToAltTypeParameters.entrySet()) {
            typeSubstitutionContext.put(originalToAltTypeParameter.getKey().getTypeConstructor(), new TypeProjectionImpl(originalToAltTypeParameter.getValue().getDefaultType()));
        }
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(typeSubstitutionContext);
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "createSubstitutorForTypeParameters"));
        }
        return typeSubstitutor;
    }
}

